/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import net.anwiba.commons.utilities.interval.IntegerInterval;

public abstract class AbstractObjectTableModel<T>
extends AbstractTableModel
implements IObjectTableModel<T> {
    private static final long serialVersionUID = -9054338041837561007L;
    private final Map<T, Set<Integer>> indexByobjectMap = new HashMap<T, Set<Integer>>();
    private final List<T> objects = new ArrayList<T>();
    private final List<IChangeableListListener<T>> listModelListeners = new ArrayList<IChangeableListListener<T>>();

    public AbstractObjectTableModel(List<T> objects) {
        this.objects.addAll(objects);
        this.refreshIndex();
    }

    @Override
    public final String getColumnName(int columnIndex) {
        return "Column" + columnIndex;
    }

    public int size() {
        return this.getRowCount();
    }

    private synchronized void refreshIndex() {
        this.indexByobjectMap.clear();
        int i = 0;
        while (i < this.objects.size()) {
            if (!this.indexByobjectMap.containsKey(this.get(i))) {
                this.indexByobjectMap.put(this.get(i), new HashSet());
            }
            this.indexByobjectMap.get(this.get(i)).add(i);
            ++i;
        }
    }

    public synchronized void set(T ... objects) {
        this.set((Iterable<T>)Arrays.asList(objects));
    }

    public synchronized void set(Iterable<T> objects) {
        List oldObjects = IterableUtilities.asList(this.objects);
        this.indexByobjectMap.clear();
        this.objects.clear();
        for (T object : objects) {
            if (!this.indexByobjectMap.containsKey(object)) {
                this.indexByobjectMap.put(object, new HashSet());
            }
            Integer index = this.getObjects().size();
            this.indexByobjectMap.get(object).add(index);
            this.objects.add(object);
        }
        this.fireTableDataChanged();
        this.fireObjectsChanged(oldObjects, IterableUtilities.asList(objects));
    }

    public synchronized void add(T ... objects) {
        this.add((Iterable<T>)Arrays.asList(objects));
    }

    public synchronized void add(Iterable<T> objects) {
        int rows = this.size();
        for (T object : objects) {
            if (!this.indexByobjectMap.containsKey(object)) {
                this.indexByobjectMap.put(object, new HashSet());
            }
            Integer index = this.getObjects().size();
            this.indexByobjectMap.get(object).add(index);
            this.objects.add(object);
        }
        this.fireTableRowsInserted(rows, this.size() - 1);
        this.fireObjectsAdded((Iterable<Integer>)new IntegerInterval(rows, this.size() - 1), objects);
    }

    public synchronized void set(int index, T object) {
        if (index >= this.getRowCount()) {
            throw new IllegalArgumentException("index out of bounds");
        }
        if (!this.indexByobjectMap.containsKey(object)) {
            this.indexByobjectMap.put(object, new HashSet());
        }
        this.indexByobjectMap.get(object).add(this.getObjects().size());
        T oldObject = this.objects.set(index, object);
        this.fireTableRowsUpdated(index, index);
        this.fireObjectsUpdated(Arrays.asList(index), Arrays.asList(oldObject), Arrays.asList(object));
    }

    public synchronized int[] indices(Iterable<T> objects) {
        HashSet indexes = new HashSet();
        for (T object : objects) {
            HashSet objectIndexes = this.indexByobjectMap.get(object);
            indexes.addAll(objectIndexes == null ? new HashSet() : objectIndexes);
        }
        return ArrayUtilities.primitives((Integer[])indexes.toArray(new Integer[indexes.size()]));
    }

    public synchronized void remove(T ... objects) {
        int[] indices = this.indices(Arrays.asList(objects));
        this.remove(indices);
    }

    public synchronized void remove(Iterable<T> objects) {
        int[] indices = this.indices(objects);
        this.remove(indices);
    }

    public synchronized void remove(int ... indices) {
        if (indices.length == 0) {
            return;
        }
        Arrays.sort(indices);
        ArrayList<T> removedObjects = new ArrayList<T>();
        HashSet<Integer> indexSet = new HashSet<Integer>();
        int i = indices.length - 1;
        while (i >= 0) {
            int index = indices[i];
            T object = this.get(index);
            T removedObject = this.objects.remove(index);
            if (removedObject != null) {
                Set<Integer> indizes = this.indexByobjectMap.get(removedObject);
                if (indizes.remove(index) && indizes.isEmpty()) {
                    this.indexByobjectMap.remove(object);
                }
                removedObjects.add(object);
                this.fireTableRowsDeleted(index, index);
            }
            --i;
        }
        this.fireObjectsRemoved(indexSet, removedObjects);
    }

    public synchronized void removeAll() {
        int rows = this.getRowCount();
        ArrayList<T> objects = new ArrayList<T>(this.objects);
        this.objects.clear();
        this.indexByobjectMap.clear();
        this.fireTableRowsDeleted(0, rows - 1);
        this.fireObjectsRemoved((Iterable<Integer>)new IntegerInterval(0, rows - 1), objects);
    }

    public synchronized Iterable<T> values() {
        return Collections.unmodifiableList(IterableUtilities.asList(this.objects));
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public final synchronized int getRowCount() {
        return this.objects.size();
    }

    public synchronized Collection<T> get(int ... indices) {
        ArrayList<T> result = new ArrayList<T>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            result.add(this.get(index));
            ++n2;
        }
        return result;
    }

    public synchronized T get(int rowIndex) {
        if (rowIndex < 0) {
            return null;
        }
        if (rowIndex >= this.objects.size()) {
            return null;
        }
        return this.objects.get(rowIndex);
    }

    protected List<T> getObjects() {
        return this.objects;
    }

    public final synchronized void addListModelListener(IChangeableListListener<T> listener) {
        this.listModelListeners.add(listener);
    }

    public final synchronized void removeListModelListener(IChangeableListListener<T> listener) {
        this.listModelListeners.remove(listener);
    }

    protected final synchronized void fireObjectsAdded(Iterable<Integer> indeces, Iterable<T> objects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners = new ArrayList<IChangeableListListener<T>>(this.listModelListeners);
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsAdded(indeces, objects);
        }
    }

    protected void fireObjectsChanged(List<T> oldObjects, List<T> newObjects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners = new ArrayList<IChangeableListListener<T>>(this.listModelListeners);
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsChanged(oldObjects, newObjects);
        }
    }

    protected final synchronized void fireObjectsUpdated(Iterable<Integer> indeces, List<T> oldObjects, List<T> newObjects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners = new ArrayList<IChangeableListListener<T>>(this.listModelListeners);
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsUpdated(indeces, oldObjects, newObjects);
        }
    }

    protected final synchronized void fireObjectsRemoved(Iterable<Integer> indeces, Iterable<T> objects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners = new ArrayList<IChangeableListListener<T>>(this.listModelListeners);
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsRemoved(indeces, objects);
        }
    }
}

