/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.IRowFilter;
import net.anwiba.commons.swing.table.IRowMapper;
import net.anwiba.commons.swing.table.filter.NeutralFilter;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.commons.utilities.collection.IterableUtilities;

public class FilterableObjectTableModel<T>
extends AbstractTableModel
implements IObjectTableModel<T> {
    private static final long serialVersionUID = -4870849336713774402L;
    private final IObjectTableModel<T> objectTableModel;
    private IRowFilter filter;
    private IRowMapper mapper;
    private boolean updateFlag = false;
    private final Object semaphor = new Object();

    public FilterableObjectTableModel(IObjectTableModel<T> objectTableModel) {
        this.objectTableModel = objectTableModel;
        this.objectTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                if (event.getType() == -1) {
                    FilterableObjectTableModel.this.fireTableStructureChanged();
                    return;
                }
                FilterableObjectTableModel.this.update();
            }
        });
        this.setRowFilter(new NeutralFilter());
    }

    IObjectTableModel<T> getObjectTableModel() {
        return this.objectTableModel;
    }

    public synchronized void setRowFilter(IRowFilter filter) {
        this.filter = filter == null ? new NeutralFilter() : filter;
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        Object object = this.semaphor;
        synchronized (object) {
            try {
                IRowMapper mapper;
                this.mapper = mapper = this.filter.filter(this.objectTableModel);
            }
            finally {
                this.updateFlag = false;
            }
        }
        this.fireTableDataChanged();
    }

    public T get(int rowIndex) {
        return (T)this.objectTableModel.get(this.getMapper().getRowIndex(rowIndex));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.objectTableModel.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.objectTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.objectTableModel.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.getMapper().getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.objectTableModel.getValueAt(this.getMapper().getRowIndex(rowIndex), columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.objectTableModel.isCellEditable(this.getMapper().getRowIndex(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.objectTableModel.setValueAt(value, this.getMapper().getRowIndex(rowIndex), columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] indices(Iterable<T> objects) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        Object object = this.semaphor;
        synchronized (object) {
            int[] indexes;
            int[] nArray = indexes = this.objectTableModel.indices(objects);
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                int result = this.getMapper().getRowIndex(index);
                if (result != -1) {
                    results.add(result);
                }
                ++n2;
            }
        }
        return ArrayUtilities.primitives((Integer[])results.toArray(new Integer[results.size()]));
    }

    public void addListModelListener(IChangeableListListener<T> listener) {
        this.objectTableModel.addListModelListener(listener);
    }

    public void removeListModelListener(IChangeableListListener<T> listener) {
        this.objectTableModel.removeListModelListener(listener);
    }

    public void add(T ... objects) {
        this.updateFlag = true;
        this.objectTableModel.add(objects);
    }

    public void add(Iterable<T> objects) {
        this.updateFlag = true;
        this.objectTableModel.add(objects);
    }

    public void set(int rowIndex, T object) {
        this.updateFlag = true;
        this.objectTableModel.set(this.getMapper().getRowIndex(rowIndex), object);
    }

    private IRowMapper getMapper() {
        if (this.updateFlag) {
            this.update();
        }
        return this.mapper;
    }

    public void remove(T ... objects) {
        this.updateFlag = true;
        this.objectTableModel.remove(objects);
    }

    public void remove(Iterable<T> objects) {
        this.updateFlag = true;
        this.objectTableModel.remove(objects);
    }

    public void removeAll() {
        this.updateFlag = true;
        this.objectTableModel.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int ... indices) {
        int[] values = new int[indices.length];
        Object object = this.semaphor;
        synchronized (object) {
            int i = 0;
            while (i < indices.length) {
                values[i] = this.getMapper().getRowIndex(indices[i]);
                ++i;
            }
        }
        this.updateFlag = true;
        this.objectTableModel.remove(values);
    }

    public int size() {
        return this.objectTableModel.size();
    }

    public void set(T ... objects) {
        this.updateFlag = true;
        this.objectTableModel.set(objects);
    }

    public void set(Iterable<T> objects) {
        this.updateFlag = true;
        this.objectTableModel.set(objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<T> values() {
        ArrayList values = new ArrayList();
        Object object = this.semaphor;
        synchronized (object) {
            IRowMapper mapper = this.getMapper();
            Iterable<Integer> indeces = mapper.indeces();
            List asList = IterableUtilities.asList(indeces);
            int[] array = ArrayUtilities.primitives((Integer[])asList.toArray(new Integer[asList.size()]));
            if (array.length > 0) {
                values.addAll(this.objectTableModel.get(array));
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> get(int ... indices) {
        ArrayList values = new ArrayList();
        Object object = this.semaphor;
        synchronized (object) {
            IRowMapper mapper = this.getMapper();
            int[] result = new int[indices.length];
            int i = 0;
            while (i < result.length) {
                result[i] = mapper.getRowIndex(indices[i]);
                ++i;
            }
            values.addAll(this.objectTableModel.get(result));
        }
        return values;
    }

    public boolean isEmpty() {
        return this.getMapper().getRowCount() == 0;
    }
}

