/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.object.StringField;
import net.anwiba.commons.swing.object.StringObjectFieldConfigurationBuilder;
import net.anwiba.commons.swing.table.FilterableObjectTableModel;
import net.anwiba.commons.swing.table.IObjectListTableConfiguration;
import net.anwiba.commons.swing.table.IRowFilter;
import net.anwiba.commons.swing.table.ObjectListTableModel;
import net.anwiba.commons.swing.table.ObjectTable;
import net.anwiba.commons.swing.table.filter.ContainsFilter;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;
import net.anwiba.commons.utilities.string.StringUtilities;

public class ObjectListTable<T>
extends ObjectTable<T> {
    private final IObjectModel<IRowFilter> rowFilterModel;
    private final IObjectListTableConfiguration<T> configuration;

    public ObjectListTable(IObjectListTableConfiguration<T> configuration, List<T> list) {
        super(configuration, new FilterableObjectTableModel<T>(new ObjectListTableModel<T>(list, configuration.getColumnValueProviders(), configuration.getColumnValueAdaptors())));
        this.configuration = configuration;
        final FilterableObjectTableModel tableModel = (FilterableObjectTableModel)this.getTableModel();
        ObjectModel rowFilterModel = new ObjectModel();
        rowFilterModel.addChangeListener(new IChangeableObjectListener((IObjectModel)rowFilterModel){
            private final /* synthetic */ IObjectModel val$rowFilterModel;
            {
                this.val$rowFilterModel = iObjectModel;
            }

            public void objectChanged() {
                tableModel.setRowFilter((IRowFilter)this.val$rowFilterModel.get());
            }
        });
        this.rowFilterModel = rowFilterModel;
        ((ObjectListTableModel)tableModel.getObjectTableModel()).setChangeable(!this.getSortStateModel().get());
        this.getSortStateModel().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                ((ObjectListTableModel)tableModel.getObjectTableModel()).setChangeable(!ObjectListTable.this.getSortStateModel().get());
            }
        });
    }

    public IObjectModel<IRowFilter> getRowFilterModel() {
        return this.rowFilterModel;
    }

    @Override
    public JComponent getComponent() {
        if (this.configuration.isFilterable()) {
            StringField stringField = new StringField(((StringObjectFieldConfigurationBuilder)new StringObjectFieldConfigurationBuilder().addClearAction("clear filter")).build());
            final IObjectModel model = stringField.getModel();
            final IObjectModel<IRowFilter> rowFilterModel = this.getRowFilterModel();
            final IColumToStringConverter filterToStringConverter = this.configuration.getRowFilterToStringConverter();
            model.addChangeListener(new IChangeableObjectListener(){

                public void objectChanged() {
                    String value = (String)model.get();
                    if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                        rowFilterModel.set(null);
                        return;
                    }
                    rowFilterModel.set((Object)new ContainsFilter(value, filterToStringConverter));
                }
            });
            JPanel contentPane = new JPanel();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)stringField.getComponent(), "North");
            contentPane.add("Center", new JScrollPane(super.getComponent()));
            return contentPane;
        }
        return super.getComponent();
    }
}

