/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.util.List;
import net.anwiba.commons.swing.table.AbstractObjectTableModel;
import net.anwiba.commons.swing.table.IColumnValueAdaptor;
import net.anwiba.commons.swing.table.IColumnValueProvider;

public class ObjectListTableModel<T>
extends AbstractObjectTableModel<T> {
    private final List<IColumnValueProvider<T>> providers;
    private final List<IColumnValueAdaptor<T>> adaptors;
    private static final long serialVersionUID = 1L;
    private boolean isChangeable = true;

    public ObjectListTableModel(List<T> objects, List<IColumnValueProvider<T>> providers, List<IColumnValueAdaptor<T>> recievers) {
        super(objects);
        this.providers = providers;
        this.adaptors = recievers;
    }

    @Override
    public int getColumnCount() {
        return this.providers.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object object = this.get(rowIndex);
        IColumnValueProvider valueProvider = this.providers.get(columnIndex);
        return valueProvider.getValue(object);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.adaptors.get(columnIndex) == null) {
            super.setValueAt(aValue, rowIndex, columnIndex);
            return;
        }
        Object object = this.get(rowIndex);
        T adapted = this.adaptors.get(columnIndex).adapt(object, aValue);
        this.set(rowIndex, adapted);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.adaptors.get(columnIndex) == null) {
            return false;
        }
        return this.isChangeable;
    }

    public void setChangeable(boolean isChangeable) {
        this.isChangeable = isChangeable;
    }
}

