/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.swing.table.IColumnObjectFactory;
import net.anwiba.commons.swing.table.IKeyListenerFactory;
import net.anwiba.commons.swing.table.IMouseListenerFactory;
import net.anwiba.commons.swing.table.IObjectListColumnConfiguration;
import net.anwiba.commons.swing.table.IObjectListTableConfiguration;
import net.anwiba.commons.swing.table.ObjectListTable;
import net.anwiba.commons.swing.table.ObjectListTableConfigurationBuilder;
import net.anwiba.commons.swing.table.action.ITableActionFactory;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;

public class ObjectTableBuilder<T> {
    final ObjectListTableConfigurationBuilder<T> builder = new ObjectListTableConfigurationBuilder();
    private final List<T> values = new ArrayList<T>();

    public ObjectTableBuilder<T> setKeyListenerFactory(IKeyListenerFactory<T> keyListenerFactory) {
        this.builder.setKeyListenerFactory(keyListenerFactory);
        return this;
    }

    public ObjectTableBuilder<T> setSelectionMode(int selectionMode) {
        this.builder.setSelectionMode(selectionMode);
        return this;
    }

    public ObjectTableBuilder<T> addColumnConfiguration(IObjectListColumnConfiguration<T> columnConfiguration) {
        this.builder.addColumnConfiguration(columnConfiguration);
        return this;
    }

    public ObjectTableBuilder<T> addActionFactory(ITableActionFactory<T> factory) {
        this.builder.addActionFactory(factory);
        return this;
    }

    public ObjectTableBuilder<T> setPreferredVisibleRowCount(int preferredVisibleRowCount) {
        this.builder.setPreferredVisibleRowCount(preferredVisibleRowCount);
        return this;
    }

    public ObjectTableBuilder<T> setMouseListenerFactory(IMouseListenerFactory<T> mouseListenerFactory) {
        this.builder.setMouseListenerFactory(mouseListenerFactory);
        return this;
    }

    public ObjectTableBuilder<T> addAddObjectAction(IColumnObjectFactory<T, T, RuntimeException> factory) {
        this.builder.addAddObjectAction(factory);
        return this;
    }

    public ObjectTableBuilder<T> addEditObjectAction(IColumnObjectFactory<T, T, RuntimeException> factory) {
        this.builder.addEditObjectAction(factory);
        return this;
    }

    public ObjectTableBuilder<T> addRemoveObjectsAction() {
        this.builder.addRemoveObjectsAction();
        return this;
    }

    public ObjectTableBuilder<T> addMoveObjectUpAction() {
        this.builder.addMoveObjectUpAction();
        return this;
    }

    public ObjectTableBuilder<T> addMoveObjectDownAction() {
        this.builder.addMoveObjectDownAction();
        return this;
    }

    public ObjectTableBuilder<T> setFilterToStringConverter(IColumToStringConverter columnToStringConverter) {
        this.builder.setFilterToStringConverter(columnToStringConverter);
        return this;
    }

    public ObjectTableBuilder<T> setValues(List<T> values) {
        this.values.clear();
        this.values.addAll(values);
        return this;
    }

    public ObjectTableBuilder<T> addValue(T value) {
        this.values.add(value);
        return this;
    }

    public ObjectListTable<T> build() {
        IObjectListTableConfiguration<T> configuration = this.builder.build();
        return new ObjectListTable<T>(configuration, this.values);
    }
}

