/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.utilities;

import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class JTableUtilities {
    public static String getToolTipText(JTable table, MouseEvent event) {
        Point point = event.getPoint();
        int rowIndex = JTableUtilities.getRealRowIndexAtPoint(table, point);
        int columnIndex = JTableUtilities.getRealColumnIndexAtPoint(table, point);
        int columnAtPoint = table.columnAtPoint(point);
        int rowAtPoint = table.rowAtPoint(point);
        TableCellRenderer tableCellRenderer = table.getCellRenderer(rowAtPoint, columnAtPoint);
        if (tableCellRenderer instanceof JLabel) {
            String value = ((JLabel)tableCellRenderer.getTableCellRendererComponent(table, table.getValueAt(rowAtPoint, columnAtPoint), false, false, rowIndex, columnIndex)).getText();
            if (value == null) {
                return null;
            }
            int columnWidth = JTableUtilities.getColumnWidth(table, columnAtPoint);
            double valueWidth = JTableUtilities.getValueWidth(tableCellRenderer, value);
            if (valueWidth > (double)(columnWidth - 2)) {
                return value;
            }
        }
        return null;
    }

    private static double getValueWidth(TableCellRenderer tableCellRenderer, String value) {
        Font font = ((JLabel)((Object)tableCellRenderer)).getFont();
        FontRenderContext frc = ((JLabel)((Object)tableCellRenderer)).getFontMetrics(font).getFontRenderContext();
        return font.getStringBounds(value, frc).getWidth();
    }

    private static int getColumnWidth(JTable table, int columnAtPoint) {
        TableColumn column = table.getColumnModel().getColumn(columnAtPoint);
        return column.getWidth();
    }

    public static int getRealColumnIndexAtPoint(JTable table, Point point) {
        return table.convertColumnIndexToModel(table.columnAtPoint(point));
    }

    public static int getRealRowIndexAtPoint(JTable table, Point point) {
        int rowIndex = table.rowAtPoint(point);
        RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
        if (rowSorter == null) {
            return rowIndex;
        }
        return rowSorter.convertRowIndexToModel(rowIndex);
    }
}

