/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object.demo;

import de.jdemo.extensions.SwingDemoCase;
import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.swing.utilities.SpringLayoutUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class AbstractObjectFieldDemo
extends SwingDemoCase {
    private static ILogger logger = Logging.getLogger((String)AbstractObjectFieldDemo.class.getName());

    protected JPanel createPanel(IObjectField<?> field) {
        return this.createPanel(field.getComponent(), field);
    }

    protected JPanel createPanel(Component component, final IObjectField<?> field) {
        final JTextField textField = new JTextField();
        textField.setEditable(false);
        final JTextField validField = new JTextField();
        validField.setEditable(false);
        field.getModel().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                logger.log(ILevel.DEBUG, MessageFormat.format("Object changed to: {0}", field.getModel().get()));
                AbstractObjectFieldDemo.this.update(field, textField, validField);
            }
        });
        field.getValidationResultDistributor().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                logger.log(ILevel.DEBUG, MessageFormat.format("valid state changed to: {0}", ((IValidationResult)field.getValidationResultDistributor().get()).isValid()));
                AbstractObjectFieldDemo.this.update(field, textField, validField);
            }
        });
        this.update(field, textField, validField);
        JPanel panel = new JPanel();
        panel.setLayout(new SpringLayout());
        panel.add(component);
        panel.add(textField);
        panel.add(validField);
        SpringLayoutUtilities.makeCompactGrid((Container)panel, (int)1, (int)3, (int)0, (int)0, (int)0, (int)0);
        return panel;
    }

    protected void update(IObjectField<?> field, final JTextField textField, final JTextField validField) {
        final IValidationResult state = (IValidationResult)field.getValidationResultDistributor().get();
        final Object value = field.getModel().get();
        GuiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                validField.setText(state.isValid() ? "valid" : MessageFormat.format("invalid: {0}", state.getMessage()));
                if (state.isValid()) {
                    String text = value == null ? null : value.toString();
                    textField.setText(text);
                    textField.setToolTipText(text);
                }
            }
        });
    }
}

