/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.component;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.swing.component.IComponentProvider;

public class CheckBox
implements IComponentProvider {
    private final BooleanModel model;
    private JCheckBox checkBox;
    private final String label;

    public CheckBox() {
        this(new BooleanModel(false));
    }

    public CheckBox(BooleanModel model) {
        this(null, model);
    }

    public CheckBox(String label, BooleanModel model) {
        this.label = label;
        this.model = model;
        this.model.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                CheckBox.this.updateView();
            }
        });
    }

    protected void updateView() {
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.getModel().setSelected(this.model.get());
    }

    @Override
    public JComponent getComponent() {
        if (this.checkBox == null) {
            this.initView();
        }
        return this.checkBox;
    }

    private void initView() {
        this.checkBox = new JCheckBox(this.label);
        this.checkBox.getModel().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CheckBox.this.updateModel();
            }
        });
        this.updateView();
    }

    protected void updateModel() {
        this.model.set(this.checkBox.isSelected());
    }

    public void setEditable(boolean isEditable) {
        if (this.checkBox == null) {
            this.initView();
        }
        this.checkBox.setEnabled(isEditable);
    }

    public BooleanModel getModel() {
        return this.model;
    }
}

