/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.component.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.anwiba.commons.lang.object.IObjectReceiver;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.component.IComponentProvider;
import net.anwiba.commons.swing.component.search.ISearchEngine;
import net.anwiba.commons.swing.component.search.action.IAdvancedSearchActionFactory;
import net.anwiba.commons.swing.component.search.action.NextAction;
import net.anwiba.commons.swing.component.search.action.PreviousAction;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.StringField;
import net.anwiba.commons.swing.object.StringObjectFieldConfigurationBuilder;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.utilities.factory.IFactory;

public class SearchComponent<C, R>
implements IComponentProvider {
    private JPanel contentPane;
    private final ISearchEngine<C, R> engine;
    private StringField stringField;
    private final JComponent[] components;
    private final IAdvancedSearchActionFactory<C> advancedSearchActionFactory;
    private final IFactory<String, C, RuntimeException> stringConditionFactory;

    public SearchComponent(ISearchEngine<C, R> engine, IFactory<String, C, RuntimeException> stringConditionFactory, JComponent ... components) {
        this(engine, stringConditionFactory, (IAdvancedSearchActionFactory<C>)null, components);
    }

    public SearchComponent(ISearchEngine<C, R> engine, IFactory<String, C, RuntimeException> stringConditionFactory, IAdvancedSearchActionFactory<C> advancedSearchActionFactory, JComponent ... components) {
        this.engine = engine;
        this.stringConditionFactory = stringConditionFactory;
        this.advancedSearchActionFactory = advancedSearchActionFactory;
        this.components = components;
    }

    @Override
    public JComponent getComponent() {
        if (this.contentPane == null) {
            StringField stringField;
            this.contentPane = new JPanel(new FlowLayout(0));
            final ISearchEngine<C, R> engine = this.engine;
            final PreviousAction previousAction = new PreviousAction(engine);
            previousAction.setEnabled(false);
            final NextAction nextAction = new NextAction(engine);
            nextAction.setEnabled(false);
            final ObjectModel searchStringModel = new ObjectModel();
            StringObjectFieldConfigurationBuilder builder = (StringObjectFieldConfigurationBuilder)((StringObjectFieldConfigurationBuilder)((StringObjectFieldConfigurationBuilder)new StringObjectFieldConfigurationBuilder().setToolTipFactory((validationResult, context) -> "feature search condition")).setColumns(24)).setModel(searchStringModel);
            if (this.advancedSearchActionFactory != null) {
                builder.addActionFactory((context, document, clearBlock) -> this.advancedSearchActionFactory.create((IObjectReceiver<String>)searchStringModel, engine));
            }
            builder.addClearAction("clear");
            builder.addActionFactory((c, d, b) -> previousAction);
            builder.addActionFactory((c, d, b) -> nextAction);
            IObjectFieldConfiguration<String> configuration = builder.build();
            this.stringField = stringField = new StringField(configuration);
            final IFactory<String, C, RuntimeException> stringConditionFactory = this.stringConditionFactory;
            searchStringModel.addChangeListener(new IChangeableObjectListener(){

                public void objectChanged() {
                    engine.search(stringConditionFactory.create((Object)((String)searchStringModel.get())));
                }
            });
            engine.getSearchResultsModel().addListModelListener(new IChangeableListListener<R>(){

                public void objectsAdded(Iterable<Integer> indeces, Iterable<R> object) {
                    this.updateComponent();
                }

                public void objectsRemoved(Iterable<Integer> indeces, Iterable<R> object) {
                    this.updateComponent();
                }

                public void objectsUpdated(Iterable<Integer> indeces, Iterable<R> oldObjects, Iterable<R> newObjects) {
                    this.updateComponent();
                }

                public void objectsChanged(Iterable<R> oldObjects, Iterable<R> newObjects) {
                    this.updateComponent();
                }

                private synchronized void updateComponent() {
                    final boolean isValid = !engine.getSearchResultsModel().isEmpty() || engine.getCondition() == null;
                    final boolean hasPrevious = engine.hasPrevious();
                    final boolean hasNext = engine.hasNext();
                    GuiUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            stringField.getComponent().setBackground(isValid ? Color.WHITE : Color.RED);
                            stringField.getComponent().setForeground(isValid ? Color.BLACK : Color.WHITE);
                            previousAction.setEnabled(hasPrevious);
                            nextAction.setEnabled(hasNext);
                        }
                    });
                }
            });
            engine.getResultCursorModel().addChangeListener(new IChangeableObjectListener(){

                public void objectChanged() {
                    final boolean hasPrevious = engine.hasPrevious();
                    final boolean hasNext = engine.hasNext();
                    GuiUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            previousAction.setEnabled(hasPrevious);
                            nextAction.setEnabled(hasNext);
                        }
                    });
                }
            });
            this.contentPane.add(this.createSearchField(stringField));
            JComponent[] jComponentArray = this.components;
            int n = this.components.length;
            int n2 = 0;
            while (n2 < n) {
                JComponent component = jComponentArray[n2];
                this.contentPane.add(component);
                ++n2;
            }
        }
        return this.contentPane;
    }

    private Component createSearchField(StringField stringField) {
        JPanel searchPanel = new JPanel(new FlowLayout(0, 0, 0));
        searchPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        searchPanel.add(stringField.getComponent());
        return searchPanel;
    }

    public void grapFocus() {
        if (this.stringField != null) {
            this.stringField.getComponent().grabFocus();
        }
    }
}

