/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.configuration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.model.SelectionModel;
import net.anwiba.commons.swing.configuration.ConfigurationUi;
import net.anwiba.commons.swing.configuration.IConfiguration;
import net.anwiba.commons.swing.list.ObjectListComponent;
import net.anwiba.commons.swing.list.ObjectListComponentModel;
import net.anwiba.commons.swing.list.ObjectListConfigurationBuilder;
import net.anwiba.commons.swing.parameter.ParameterTable;
import net.anwiba.commons.swing.parameter.ParameterTableModel;

public class ConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public ConfigurationPanel(List<IConfiguration> configurations) {
        super(new BorderLayout());
        ObjectListComponent<IConfiguration> configurationList = this.createConfigurationList(configurations);
        JScrollPane configurationScrollPane = new JScrollPane(configurationList.getComponent());
        configurationScrollPane.setPreferredSize(new Dimension(150, 200));
        final ParameterTableModel parameterTableModel = new ParameterTableModel();
        JScrollPane parameterScrollPane = new JScrollPane(new ParameterTable(parameterTableModel));
        parameterScrollPane.setPreferredSize(new Dimension(300, 200));
        JSplitPane splitPane = new JSplitPane(1, configurationScrollPane, parameterScrollPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(1.0);
        this.add((Component)splitPane, "Center");
        final SelectionModel<IConfiguration> selectionModel = configurationList.getSelectionModel();
        selectionModel.addSelectionListener((ISelectionListener)new ISelectionListener<IConfiguration>(){

            public void selectionChanged(SelectionEvent<IConfiguration> event) {
                ConfigurationPanel.this.updateParameters((SelectionModel<IConfiguration>)selectionModel, parameterTableModel);
            }
        });
        this.updateParameters(selectionModel, parameterTableModel);
    }

    protected final void updateParameters(SelectionModel<IConfiguration> selectionModel, ParameterTableModel parameterTableModel) {
        if (selectionModel.isEmpty()) {
            parameterTableModel.setParameters(null);
            return;
        }
        IConfiguration configuration = (IConfiguration)selectionModel.getSelectedObjects().iterator().next();
        parameterTableModel.setParameters(configuration.getParameters());
    }

    private ObjectListComponent<IConfiguration> createConfigurationList(List<IConfiguration> configurations) {
        ObjectListConfigurationBuilder<IConfiguration> builder = new ObjectListConfigurationBuilder<IConfiguration>();
        builder.setVisibleRowCount(-1);
        builder.setSingleSelectionMode();
        builder.setObjectUi(new ConfigurationUi());
        ObjectListComponent<IConfiguration> list = new ObjectListComponent<IConfiguration>(builder.build(), new ObjectListComponentModel<IConfiguration>(configurations));
        return list;
    }
}

