/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Color;
import javax.swing.Icon;
import net.anwiba.commons.message.IMessageTypeVisitor;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.swing.icon.GuiIconSize;
import net.anwiba.commons.swing.icon.GuiIcons;

public class MessageTypeUI {
    public static Icon getIcon(MessageType messageType, GuiIconSize size) {
        return MessageTypeUI.getIcon(messageType, null, size);
    }

    public static Icon getIcon(MessageType messageType, final Icon defaultIcon, final GuiIconSize size) {
        IMessageTypeVisitor<Icon> visitor = new IMessageTypeVisitor<Icon>(){
            Icon result;

            public Icon getResult() {
                return this.result;
            }

            public void visitInfo() {
                this.result = GuiIcons.INFORMATION_ICON.getIcon(size);
            }

            public void visitError() {
                this.result = GuiIcons.ERROR_ICON.getIcon(size);
            }

            public void visitWarning() {
                this.result = GuiIcons.WARNING_ICON.getIcon(size);
            }

            public void visitDefault() {
                this.result = defaultIcon;
            }

            public void visitQuery() {
                this.result = GuiIcons.QUERY_ICON.getIcon(size);
            }
        };
        messageType.accept((IMessageTypeVisitor)visitor);
        return (Icon)visitor.getResult();
    }

    public static Color getColor(MessageType messageType) {
        IMessageTypeVisitor<Color> visitor = new IMessageTypeVisitor<Color>(){
            Color result;

            public Color getResult() {
                return this.result;
            }

            public void visitInfo() {
                this.result = Color.BLUE;
            }

            public void visitError() {
                this.result = Color.RED;
            }

            public void visitWarning() {
                this.result = Color.ORANGE;
            }

            public void visitDefault() {
                this.result = Color.BLACK;
            }

            public void visitQuery() {
                this.result = Color.BLACK;
            }
        };
        messageType.accept((IMessageTypeVisitor)visitor);
        return (Color)visitor.getResult();
    }
}

