/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.tabbed;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.IMessageConstants;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IDataStateListener;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.dialog.tabbed.IDialogTab;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.preference.IWindowPreferences;

public class TabbedDialog
extends MessageDialog {
    private static final long serialVersionUID = 1L;
    final JTabbedPane tabbedPanel = new JTabbedPane();
    final List<IDialogTab> tabs = new ArrayList<IDialogTab>();

    public TabbedDialog(Window owner, String title) {
        this(owner, title, IMessageConstants.EMPTY_MESSAGE, (Icon)GuiIcons.EMPTY_ICON.getLargeIcon(), DialogType.CANCEL_APPLY_OK, true);
    }

    public TabbedDialog(Window owner, String title, IMessage message, Icon icon, DialogType dialogType) {
        this(owner, title, message, icon, dialogType, true);
    }

    public TabbedDialog(Window owner, String title, IMessage message, Icon icon, DialogType dialogType, boolean modal) {
        super(owner, title, message, icon, dialogType, modal);
        this.createTabbedView((IFunction<Void, Iterable<IDialogTab>, RuntimeException>)((IFunction)i -> new ArrayList()));
        this.locate();
    }

    public TabbedDialog(Window owner, IWindowPreferences preferences, String title, IFunction<Void, Iterable<IDialogTab>, RuntimeException> tabsFactory) {
        this(owner, preferences, title, IMessageConstants.EMPTY_MESSAGE, GuiIcons.EMPTY_ICON.getLargeIcon(), DialogType.CANCEL_APPLY_OK, true, tabsFactory);
    }

    public TabbedDialog(Window owner, IWindowPreferences preferences, String title, IMessage message, Icon icon, DialogType dialogType, IFunction<Void, Iterable<IDialogTab>, RuntimeException> tabsFactory) {
        this(owner, preferences, title, message, icon, dialogType, true, tabsFactory);
    }

    public TabbedDialog(Window owner, IWindowPreferences preferences, String title, IMessage message, Icon icon, DialogType dialogType, boolean modal, IFunction<Void, Iterable<IDialogTab>, RuntimeException> tabsFactory) {
        super(owner, preferences, title, message, icon, dialogType, modal);
        this.createTabbedView(tabsFactory);
        this.locate();
    }

    private void createTabbedView(IFunction<Void, Iterable<IDialogTab>, RuntimeException> tabsFactory) {
        this.tabbedPanel.setMinimumSize(new Dimension(100, 100));
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add("Center", this.tabbedPanel);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        for (IDialogTab tab : (Iterable)tabsFactory.execute(null)) {
            this.addTab(tab);
        }
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int selectedIndex = TabbedDialog.this.tabbedPanel.getSelectedIndex();
                if (selectedIndex < 0) {
                    TabbedDialog.this.setIcon(GuiIcons.EMPTY_ICON.getLargeIcon());
                    TabbedDialog.this.setMessage(IMessageConstants.EMPTY_MESSAGE);
                    return;
                }
                IDialogTab currentTab = TabbedDialog.this.tabs.get(selectedIndex);
                currentTab.updateView();
                currentTab.checkFieldValues();
                TabbedDialog.this.setIcon(currentTab.getIcon());
                TabbedDialog.this.setMessage(currentTab.getMessage());
                TabbedDialog.this.checkButton(currentTab);
            }
        });
    }

    @Override
    protected boolean apply() {
        int selectedIndex = this.tabbedPanel.getSelectedIndex();
        if (selectedIndex < 0) {
            return true;
        }
        IDialogTab tab = this.tabs.get(selectedIndex);
        return tab.apply();
    }

    public void addTab(final IDialogTab dialogTab) {
        this.tabs.add(dialogTab);
        dialogTab.addDataStateListener(new IDataStateListener(){

            @Override
            public void dataStateChanged() {
                TabbedDialog.this.setMessage(dialogTab.getMessage());
                TabbedDialog.this.checkButton(dialogTab);
            }
        });
        dialogTab.setOwnerWindow(this.getOwner());
        this.tabbedPanel.addTab(dialogTab.getTitle(), dialogTab.getComponent());
    }

    void checkButton(IDialogTab dialogTab) {
        DataState dataState = dialogTab.getDataState();
        this.checkButton(dataState);
    }

    public void setSelectedTab(int index) {
        this.tabbedPanel.setSelectedIndex(index);
    }

    protected void setSelectedTab(IDialogTab tab) {
        this.tabbedPanel.setSelectedComponent(tab.getComponent());
    }
}

