/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.wizard;

import java.awt.Container;
import java.util.List;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JPanel;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectDistributor;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.wizard.IWizardController;
import net.anwiba.commons.swing.dialog.wizard.IWizardPage;
import net.anwiba.commons.swing.dialog.wizard.IWizardState;
import net.anwiba.commons.swing.dialog.wizard.WizardState;
import net.anwiba.commons.swing.icon.GuiIcons;

public abstract class AbstractWizardController
implements IWizardController {
    private final Object mutex = new Object();
    private final BooleanModel nextEnabledModel = new BooleanModel(true);
    private final IChangeableObjectListener nextEnableListener = new IChangeableObjectListener(){

        public void objectChanged() {
            AbstractWizardController.this.nextEnabledModel.set(AbstractWizardController.this.currentPage.getNextEnabledModel().get());
        }
    };
    private final BooleanModel backEnabledModel = new BooleanModel(true);
    private final IChangeableObjectListener backEnableListener = new IChangeableObjectListener(){

        public void objectChanged() {
            AbstractWizardController.this.backEnabledModel.set(AbstractWizardController.this.currentPage.getBackEnabledModel().get());
        }
    };
    private final IObjectModel<DataState> dataStateModel;
    private final IChangeableObjectListener dataStateListener;
    private final IObjectModel<String> messageModel = new ObjectModel();
    private final IChangeableObjectListener messageListener = new IChangeableObjectListener(){

        public void objectChanged() {
            if (AbstractWizardController.this.currentPage == null) {
                AbstractWizardController.this.messageModel.set(null);
                return;
            }
            AbstractWizardController.this.messageModel.set((Object)((String)AbstractWizardController.this.currentPage.getMessageDistributor().get()));
        }
    };
    private final List<IWizardPage> container;
    private final Stack<Integer> visitedPages = new Stack();
    private final IObjectModel<IWizardState> wizardStateModel = new ObjectModel();
    private IWizardPage currentPage;
    private int index = -1;

    public AbstractWizardController(List<IWizardPage> container, IObjectModel<DataState> dataStateModel) {
        this.container = container;
        this.dataStateModel = dataStateModel;
        this.dataStateListener = new IChangeableObjectListener(){

            public void objectChanged() {
                IWizardPage page = AbstractWizardController.this.currentPage;
                AbstractWizardController.this.dataStateModel.set((Object)((DataState)((Object)page.getDataStateModel().get())));
            }
        };
        this.next();
    }

    @Override
    public boolean hasNext() {
        if (this.index < 0 && !this.container.isEmpty()) {
            return true;
        }
        IWizardPage page = this.container.get(this.index);
        int i = this.index + 1;
        while (i < this.container.size()) {
            if (this.container.get(i).isApplicable(page)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean hasPrevious() {
        return !this.visitedPages.isEmpty();
    }

    protected IWizardPage getPrevious() {
        if (this.visitedPages.isEmpty()) {
            return this.container.get(this.index);
        }
        this.index = this.visitedPages.pop();
        return this.container.get(this.index);
    }

    protected IWizardPage getNext() {
        if (this.index < 0) {
            this.index = 0;
            return this.container.get(this.index);
        }
        IWizardPage page = this.container.get(this.index);
        int i = this.index + 1;
        while (i < this.container.size()) {
            if (this.container.get(i).isApplicable(page)) {
                this.visitedPages.add(this.index);
                this.index = i;
                return this.container.get(this.index);
            }
            ++i;
        }
        return this.container.get(this.index);
    }

    @Override
    public void previous() {
        if (this.hasPrevious()) {
            this.updateWizardState(this.getPrevious());
        }
    }

    @Override
    public void next() {
        if (this.hasNext()) {
            this.updateWizardState(this.getNext());
        }
    }

    @Override
    public boolean cancel() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finish() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentPage.finishable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWizardState(IWizardPage page) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.currentPage != null) {
                this.currentPage.getNextEnabledModel().removeChangeListener(this.nextEnableListener);
                this.currentPage.getBackEnabledModel().removeChangeListener(this.backEnableListener);
                this.currentPage.getDataStateModel().removeChangeListener(this.dataStateListener);
                this.currentPage.getMessageDistributor().removeChangeListener(this.messageListener);
            }
            this.currentPage = page;
            this.nextEnabledModel.set(this.currentPage.getNextEnabledModel().get() && this.hasNext());
            this.backEnabledModel.set(this.currentPage.getBackEnabledModel().get() && this.hasPrevious());
            this.dataStateModel.set((Object)((DataState)((Object)this.currentPage.getDataStateModel().get())));
            this.currentPage.getNextEnabledModel().addChangeListener(this.nextEnableListener);
            this.currentPage.getBackEnabledModel().addChangeListener(this.backEnableListener);
            this.currentPage.getDataStateModel().addChangeListener(this.dataStateListener);
            this.currentPage.getMessageDistributor().addChangeListener(this.messageListener);
        }
        this.wizardStateModel.set((Object)new WizardState());
    }

    @Override
    public void addChangeListener(IChangeableObjectListener changeableObjectListener) {
        this.wizardStateModel.addChangeListener(changeableObjectListener);
    }

    @Override
    public void removeChangeListener(IChangeableObjectListener changeableObjectListener) {
        this.wizardStateModel.removeChangeListener(changeableObjectListener);
    }

    @Override
    public IWizardState getWizardState() {
        return (IWizardState)this.wizardStateModel.get();
    }

    @Override
    public boolean isFinishable() {
        return this.currentPage.finishable();
    }

    @Override
    public IBooleanDistributor getNextEnabledDistributor() {
        return this.nextEnabledModel;
    }

    @Override
    public IBooleanDistributor getBackEnabledDistributor() {
        return this.backEnabledModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMessage getMessage() {
        Object object = this.mutex;
        synchronized (object) {
            block5: {
                if (this.currentPage != null) break block5;
                return null;
            }
            String message = this.currentPage.getMessage();
            if (DataState.INVALIDE.equals(this.dataStateModel.get())) {
                return Message.create((String)this.currentPage.getTitle(), (String)message, (MessageType)MessageType.ERROR);
            }
            return Message.create((String)this.currentPage.getTitle(), (String)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Icon getIcon() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.currentPage == null) {
                return GuiIcons.EMPTY_ICON.getLargeIcon();
            }
            return this.currentPage.getIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container getContentPane() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.currentPage == null) {
                return new JPanel();
            }
            return this.currentPage.getComponent();
        }
    }

    @Override
    public IObjectDistributor<DataState> getDataStateDistributor() {
        return this.dataStateModel;
    }

    @Override
    public IObjectDistributor<String> getMessageDistributor() {
        return this.messageModel;
    }

    @Override
    public boolean apply() {
        return true;
    }
}

