/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.wizard;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessageConstants;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IAdditionalActionFactory;
import net.anwiba.commons.swing.dialog.IDataStateVisitor;
import net.anwiba.commons.swing.dialog.IDialogResult;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.dialog.wizard.IWizardController;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.preference.IWindowPreferences;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class WizardDialog
extends MessageDialog {
    private static final long serialVersionUID = 1L;
    private final IWizardController controller;
    static ILogger logger = Logging.getLogger((String)WizardDialog.class.getName());
    private AbstractAction nextAction;
    private AbstractAction backAction;

    public WizardDialog(Window owner, IWindowPreferences preferences, String title, final IWizardController controller) {
        super(owner, preferences, title, IMessageConstants.EMPTY_MESSAGE, GuiIcons.EMPTY_ICON.getLargeIcon(), DialogType.NONE, true);
        this.controller = controller;
        this.controller.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                WizardDialog.this.updateState();
            }
        });
        this.controller.getNextEnabledDistributor().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                WizardDialog.this.updateNextAction(WizardDialog.this.getNextAction());
            }
        });
        this.controller.getBackEnabledDistributor().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                WizardDialog.this.updateBackAction(WizardDialog.this.getBackAction());
            }
        });
        this.controller.getDataStateDistributor().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                WizardDialog.this.setIcon(controller.getIcon());
                WizardDialog.this.updateOkAction();
            }
        });
        this.controller.getMessageDistributor().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                WizardDialog.this.setMessage(controller.getMessage());
            }
        });
        this.updateState();
        this.locate();
    }

    @Override
    protected Action[] getActions(DialogType dialogType, IObjectModel<IDialogResult> dialogResultModel, List<IAdditionalActionFactory> additionalActionFactories) {
        Action[] actions = new Action[]{this.getBackAction(), this.getNextAction(), this.getCancelAction(), this.getOkAction(DialogMessages.FINISH)};
        return actions;
    }

    public final Action getNextAction() {
        if (this.nextAction == null) {
            AbstractAction action;
            this.nextAction = action = new AbstractAction(DialogMessages.NEXT){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        WizardDialog.this.next();
                    }
                    catch (Exception exception) {
                        logger.log(ILevel.ERROR, "", (Throwable)exception);
                    }
                }
            };
        }
        return this.nextAction;
    }

    public final Action getBackAction() {
        if (this.backAction == null) {
            AbstractAction action;
            this.backAction = action = new AbstractAction(DialogMessages.BACK){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        WizardDialog.this.back();
                    }
                    catch (Exception exception) {
                        logger.log(ILevel.ERROR, "", (Throwable)exception);
                    }
                }
            };
        }
        return this.backAction;
    }

    @Override
    protected final boolean cancel() {
        return this.controller.cancel();
    }

    @Override
    protected final boolean apply() {
        return this.controller.apply();
    }

    protected final void next() {
        this.controller.next();
    }

    protected final void back() {
        this.controller.previous();
    }

    protected final void updateState() {
        this.controller.getWizardState();
        this.setIcon(this.controller.getIcon());
        this.setMessage(this.controller.getMessage());
        this.setContentPane(this.controller.getContentPane());
        this.updateOkAction();
        this.updateNextAction(this.getNextAction());
        this.updateBackAction(this.getBackAction());
    }

    protected final void updateOkAction() {
        this.checkButton((DataState)((Object)this.controller.getDataStateDistributor().get()));
    }

    @Override
    protected void checkButton(DataState dataState) {
        if (!this.controller.isFinishable()) {
            this.setChangeButtonsEnabled(false, false);
            return;
        }
        dataState.accept(new IDataStateVisitor(){

            @Override
            public void visitInvalide() {
                WizardDialog.this.setChangeButtonsEnabled(false, false);
            }

            @Override
            public void visitModified() {
                WizardDialog.this.setChangeButtonsEnabled(true, true);
            }

            @Override
            public void visitUnknown() {
                WizardDialog.this.setChangeButtonsEnabled(false, false);
            }

            @Override
            public void visitValide() {
                WizardDialog.this.setChangeButtonsEnabled(false, true);
            }
        });
    }

    protected final void updateNextAction(Action action) {
        GuiUtilities.invokeLater(() -> action.setEnabled(this.controller.hasNext() && this.controller.getNextEnabledDistributor().get()));
    }

    protected final void updateBackAction(Action action) {
        GuiUtilities.invokeLater(() -> action.setEnabled(this.controller.hasPrevious() && this.controller.getBackEnabledDistributor().get()));
    }
}

