/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.filechooser;

import java.awt.Window;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.anwiba.commons.preferences.DummyPreferences;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.preferences.UserPreferencesFactory;
import net.anwiba.commons.swing.filechooser.FileChooserDialog;
import net.anwiba.commons.swing.filechooser.IAccessoryFactory;
import net.anwiba.commons.swing.filechooser.IFileChooserConfiguration;
import net.anwiba.commons.swing.filechooser.IFileChooserResult;
import net.anwiba.commons.swing.filechooser.IOpenFileChooserConfiguration;
import net.anwiba.commons.swing.filechooser.ISaveFileChooserConfiguration;
import net.anwiba.commons.swing.preference.WindowPreferences;

public class FileChoosers {
    public static final String FOLDER = "folder";
    public static final String DEFAULT_PREFERENCE_NODE = "filechooser";
    public static final String FILECHOOSER_PREFERENCES_PATH = "/net/anwiba/gui";

    public static IFileChooserResult show(Window owner, IOpenFileChooserConfiguration configuration) {
        return FileChoosers.show(owner, new UserPreferencesFactory(new String[0]).create(FILECHOOSER_PREFERENCES_PATH).node(new String[]{DEFAULT_PREFERENCE_NODE}), configuration);
    }

    public static IFileChooserResult show(Window owner, IPreferences preferences, IOpenFileChooserConfiguration configuration) {
        final JFileChooser fileChooser = FileChoosers.createOpenFileChooser(preferences, configuration);
        final int returnVal = fileChooser.showOpenDialog(owner);
        if (returnVal == 0) {
            File currentDirectory = fileChooser.getCurrentDirectory();
            preferences.put(FOLDER, currentDirectory.getAbsolutePath());
        }
        return new IFileChooserResult(){

            @Override
            public int getReturnState() {
                return returnVal;
            }

            @Override
            public File getSelectedFile() {
                return fileChooser.getSelectedFile();
            }

            @Override
            public File[] getSelectedFiles() {
                return fileChooser.getSelectedFiles();
            }

            @Override
            public FileFilter getFileFilter() {
                return fileChooser.getFileFilter();
            }
        };
    }

    public static JFileChooser createSaveFileChooser(IPreferences preferences, ISaveFileChooserConfiguration configuration) {
        JFileChooser fileChooser = FileChoosers.createFileChooser(preferences, configuration);
        if (configuration.getPresetFile() != null) {
            fileChooser.setSelectedFile(configuration.getPresetFile());
        }
        fileChooser.setDialogType(1);
        fileChooser.setSelectedFile(configuration.getPresetFile());
        return fileChooser;
    }

    public static JFileChooser createOpenFileChooser(IPreferences preferences, IOpenFileChooserConfiguration configuration) {
        JFileChooser fileChooser = FileChoosers.createFileChooser(preferences, configuration);
        IAccessoryFactory accessoryFactory = configuration.getFileViewFactory();
        fileChooser.setAccessory(accessoryFactory.create(fileChooser));
        fileChooser.setDialogType(0);
        return fileChooser;
    }

    private static JFileChooser createFileChooser(IPreferences preferences, IFileChooserConfiguration configuration) {
        WindowPreferences windowPreferences = preferences == null ? new WindowPreferences((IPreferences)new DummyPreferences(new String[0])) : new WindowPreferences(preferences);
        FileChooserDialog fileChooser = new FileChooserDialog(windowPreferences);
        Iterable<FileFilter> fileFilters = configuration.getFileFilters();
        fileChooser.setAcceptAllFileFilterUsed(configuration.isAllFilterEnabled() && configuration.getFileSelectionMode() != 1);
        for (FileFilter filter : fileFilters) {
            fileChooser.addChoosableFileFilter(filter);
        }
        if (!configuration.isAllFilterEnabled()) {
            fileChooser.setFileFilter(fileFilters.iterator().next());
        }
        String path = preferences == null ? null : preferences.get(FOLDER, null);
        fileChooser.setCurrentDirectory(path == null ? null : new File(path));
        fileChooser.setFileSelectionMode(configuration.getFileSelectionMode());
        fileChooser.setMultiSelectionEnabled(configuration.isMultiSelectionEnabled());
        return fileChooser;
    }

    public static IFileChooserResult show(Window owner, ISaveFileChooserConfiguration configuration) {
        return FileChoosers.show(owner, new UserPreferencesFactory(new String[0]).create(FILECHOOSER_PREFERENCES_PATH).node(new String[]{DEFAULT_PREFERENCE_NODE}), configuration);
    }

    public static IFileChooserResult show(Window owner, IPreferences preferences, ISaveFileChooserConfiguration configuration) {
        final JFileChooser fileChooser = FileChoosers.createSaveFileChooser(preferences, configuration);
        final int returnVal = fileChooser.showSaveDialog(owner);
        if (returnVal == 0) {
            File currentDirectory = fileChooser.getCurrentDirectory();
            if (preferences != null) {
                preferences.put(FOLDER, currentDirectory.getAbsolutePath());
            }
        }
        return new IFileChooserResult(){

            @Override
            public int getReturnState() {
                return returnVal;
            }

            @Override
            public File getSelectedFile() {
                return fileChooser.getSelectedFile();
            }

            @Override
            public File[] getSelectedFiles() {
                return fileChooser.getSelectedFiles();
            }

            @Override
            public FileFilter getFileFilter() {
                return fileChooser.getFileFilter();
            }
        };
    }
}

