/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.swing.list.IListModel;
import net.anwiba.commons.utilities.ArrayUtilities;

public abstract class AbstractObjectListComponentModel<T>
extends AbstractListModel<T>
implements IListModel<T> {
    private static final long serialVersionUID = -5250421928985085227L;
    private final Map<T, Integer> indexByobjectMap = new HashMap<T, Integer>();
    private final List<T> objects = new ArrayList<T>();
    private final List<IChangeableListListener<T>> listModelListeners = new ArrayList<IChangeableListListener<T>>();

    public AbstractObjectListComponentModel(List<T> objects) {
        this.objects.addAll(objects);
        this.refreshIndex();
    }

    private synchronized void refreshIndex() {
        this.indexByobjectMap.clear();
        int i = 0;
        while (i < this.objects.size()) {
            this.indexByobjectMap.put(this.getObject(i), i);
            ++i;
        }
    }

    @Override
    public int getSize() {
        return this.objects.size();
    }

    public synchronized void add(T ... objects) {
        int rows = this.getSize();
        int i = 0;
        while (i < objects.length) {
            this.indexByobjectMap.put(objects[i], this.getSize());
            this.objects.add(objects[i]);
            ++i;
        }
        this.fireIntervalAdded(null, rows, rows + objects.length - 1);
        this.fireObjectAdded(Arrays.asList(objects));
    }

    public synchronized void remove(T ... objects) {
        int[] indices = this.getIndicesOf(Arrays.asList(objects));
        if (indices.length == 0) {
            return;
        }
        Arrays.sort(indices);
        int i = indices.length - 1;
        while (i >= 0) {
            int index = indices[i];
            if (this.objects.remove(this.getObject(index))) {
                this.fireIntervalRemoved(null, index, index);
            }
            --i;
        }
        this.refreshIndex();
    }

    public synchronized void removeAll() {
        int rows = this.getSize();
        ArrayList<T> objects = new ArrayList<T>(this.objects);
        this.objects.clear();
        this.indexByobjectMap.clear();
        this.fireIntervalRemoved(null, 0, rows - 1);
        this.fireObjectRemoved(objects);
    }

    @Override
    public T getObject(int index) {
        return this.objects.get(index);
    }

    @Override
    public T getElementAt(int index) {
        return this.getObject(index);
    }

    @Override
    public int[] getIndicesOf(List<T> objects) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (T object : objects) {
            Integer index = this.indexByobjectMap.get(object);
            if (index == null) continue;
            indexes.add(index);
        }
        return ArrayUtilities.primitives((Integer[])indexes.toArray(new Integer[indexes.size()]));
    }

    @Override
    public final synchronized void addListModelListener(IChangeableListListener<T> listener) {
        this.listModelListeners.add(listener);
    }

    @Override
    public final synchronized void removeListModelListener(IChangeableListListener<T> listener) {
        this.listModelListeners.remove(listener);
    }

    protected final synchronized void fireObjectAdded(Iterable<T> objects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners = new ArrayList<IChangeableListListener<T>>(this.listModelListeners);
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsAdded(null, objects);
        }
    }

    protected final synchronized void fireObjectRemoved(Iterable<T> objects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners = new ArrayList<IChangeableListListener<T>>(this.listModelListeners);
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsRemoved(null, objects);
        }
    }
}

