/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.menu;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.swing.menu.ActionListModel;

public class ActionListMenu
extends JMenu {
    private static final long serialVersionUID = 1L;

    public ActionListMenu(String title, ActionListModel actionListModel) {
        super(title);
        actionListModel.addListModelListener((IChangeableListListener)new IChangeableListListener<Action>(){

            public void objectsAdded(Iterable<Integer> indeces, Iterable<Action> actions) {
                for (Action action : actions) {
                    ActionListMenu.this.add(action);
                }
            }

            public void objectsRemoved(Iterable<Integer> indeces, Iterable<Action> objects) {
                for (Action action : objects) {
                    ActionListMenu.this.remove(action);
                }
            }

            public void objectsUpdated(Iterable<Integer> indeces, Iterable<Action> oldObjects, Iterable<Action> newObjects) {
                for (Action action : oldObjects) {
                    ActionListMenu.this.remove(action);
                }
                for (Action action : newObjects) {
                    ActionListMenu.this.add(action);
                }
            }

            public void objectsChanged(Iterable<Action> oldObjects, Iterable<Action> newObjects) {
                for (Action action : oldObjects) {
                    ActionListMenu.this.remove(action);
                }
                for (Action action : newObjects) {
                    ActionListMenu.this.add(action);
                }
            }
        });
    }

    void remove(Action action) {
        int i = 0;
        while (i < this.getItemCount()) {
            JMenuItem item = this.getItem(i);
            if (item.getAction().equals(action)) {
                this.remove(item);
                return;
            }
            ++i;
        }
    }
}

