/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.menu;

import java.io.Serializable;
import java.util.Comparator;
import net.anwiba.commons.swing.menu.AbstractMenuItemConfiguration;
import net.anwiba.commons.swing.menu.AbstractMenuItemDescription;
import net.anwiba.commons.swing.menu.MenuItemGroupDescription;
import net.anwiba.commons.utilities.registry.KeyValueRegistry;

public class MenuItemGroupConfiguration {
    private final MenuItemGroupDescription description;
    private final KeyValueRegistry<AbstractMenuItemDescription, AbstractMenuItemConfiguration> registry = new KeyValueRegistry();
    final Comparator<AbstractMenuItemDescription> comparator = new MenuItemDescriptionComparator();

    public MenuItemGroupConfiguration(MenuItemGroupDescription menuGroupDescription) {
        this.description = menuGroupDescription;
    }

    public MenuItemGroupDescription getDescription() {
        return this.description;
    }

    public void add(AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> menuItem) {
        this.registry.register((Object)menuItem.getDescription(), menuItem);
    }

    public void remove(AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> menuItem) {
        this.registry.remove((Object)menuItem.getDescription());
    }

    public boolean isEmpty() {
        return this.registry.isEmpty();
    }

    public AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] getMenuItemConfiguration() {
        return (AbstractMenuItemConfiguration[])this.registry.getItems(this.comparator, AbstractMenuItemDescription.class, AbstractMenuItemConfiguration.class);
    }

    public static final class MenuItemDescriptionComparator
    implements Comparator<AbstractMenuItemDescription>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(AbstractMenuItemDescription o1, AbstractMenuItemDescription o2) {
            return Integer.valueOf(o1.getWeight()).compareTo(o2.getWeight());
        }
    }
}

