/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.menu;

import java.text.MessageFormat;
import java.util.Comparator;
import javax.swing.Box;
import javax.swing.JMenuBar;
import net.anwiba.commons.swing.menu.AbstractMenuItemConfiguration;
import net.anwiba.commons.swing.menu.AbstractMenuItemDescription;
import net.anwiba.commons.swing.menu.IMenuRegistry;
import net.anwiba.commons.swing.menu.MenuConfiguration;
import net.anwiba.commons.swing.menu.MenuDescription;
import net.anwiba.commons.swing.menu.MenuItemGroupConfiguration;
import net.anwiba.commons.swing.menu.MenuItemGroupDescription;
import net.anwiba.commons.swing.menu.MenuItemType;
import net.anwiba.commons.swing.menu.MenuMenuItemConfiguration;
import net.anwiba.commons.swing.menu.MenuType;
import net.anwiba.commons.utilities.registry.KeyValueRegistry;

public class MenuManager
implements IMenuRegistry {
    private final KeyValueRegistry<MenuDescription, MenuConfiguration> registry = new KeyValueRegistry();
    static final Comparator<MenuDescription> comparator = new Comparator<MenuDescription>(){

        @Override
        public int compare(MenuDescription o1, MenuDescription o2) {
            return Integer.valueOf(o1.getWeight()).compareTo(o2.getWeight());
        }
    };

    private synchronized void addConfiguration(AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> menuItem) {
        MenuItemGroupDescription menuGroupDescription;
        MenuItemGroupConfiguration menuGroup;
        MenuDescription menuDescription = menuItem.getDescription().getMenuDescription();
        MenuConfiguration menu = (MenuConfiguration)this.registry.get((Object)menuDescription);
        if (menu == null) {
            menu = new MenuConfiguration(menuDescription);
            this.registry.register((Object)menuDescription, (Object)menu);
        }
        if (MenuItemType.MENU.equals((Object)menuItem.getDescription().getMenuItemType())) {
            if (!(menuItem instanceof MenuMenuItemConfiguration)) {
                throw new IllegalArgumentException(MessageFormat.format("Illegal type MENU and class {0} combination", menuItem.getClass()));
            }
            MenuConfiguration subMenu = ((MenuMenuItemConfiguration)menuItem).getMenuConfiguration();
            if (!this.registry.contains((Object)subMenu.getDescription())) {
                this.registry.register((Object)subMenu.getDescription(), (Object)subMenu);
            }
        }
        if ((menuGroup = menu.get(menuGroupDescription = menuItem.getDescription().getMenuGroupDescription())) == null) {
            menuGroup = new MenuItemGroupConfiguration(menuGroupDescription);
            menu.add(menuGroup);
        }
        menuGroup.add(menuItem);
    }

    @Override
    public void add(AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> ... configurations) {
        AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] abstractMenuItemConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> confguration = abstractMenuItemConfigurationArray[n2];
            this.addConfiguration(confguration);
            ++n2;
        }
    }

    private synchronized void remove(AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> menuItem) {
        MenuDescription menuDescription = menuItem.getDescription().getMenuDescription();
        MenuConfiguration menu = (MenuConfiguration)this.registry.get((Object)menuDescription);
        if (menu == null) {
            return;
        }
        MenuItemGroupDescription menuGroupDescription = menuItem.getDescription().getMenuGroupDescription();
        MenuItemGroupConfiguration menuGroup = menu.get(menuGroupDescription);
        if (menuGroup == null) {
            return;
        }
        menuGroup.remove(menuItem);
        if (menuGroup.isEmpty()) {
            menu.remove(menuGroup);
        }
        if (menu.isEmpty()) {
            this.registry.remove((Object)menuDescription);
        }
    }

    public void remove(AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] menuItems) {
        AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] abstractMenuItemConfigurationArray = menuItems;
        int n = menuItems.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> menuItem = abstractMenuItemConfigurationArray[n2];
            this.remove(menuItem);
            ++n2;
        }
    }

    public JMenuBar getMenuBar() {
        MenuConfiguration[] menus = (MenuConfiguration[])this.registry.getItems(comparator, MenuDescription.class, MenuConfiguration.class);
        JMenuBar menuBar = new JMenuBar();
        boolean isBoxAdded = false;
        MenuConfiguration[] menuConfigurationArray = menus;
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            MenuConfiguration menu = menuConfigurationArray[n2];
            if (menu.getMenuType() == MenuType.MENU) {
                if (menu.getDescription().getWeight() == Integer.MAX_VALUE && !isBoxAdded) {
                    menuBar.add(Box.createHorizontalGlue());
                    isBoxAdded = true;
                }
                menuBar.add(menu.getJMenu());
            }
            ++n2;
        }
        return menuBar;
    }
}

