/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.menu;

import java.io.Serializable;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import net.anwiba.commons.swing.menu.AbstractMenuItemConfiguration;
import net.anwiba.commons.swing.menu.AbstractMenuItemDescription;
import net.anwiba.commons.swing.menu.MenuItemButtomFactory;
import net.anwiba.commons.swing.menu.MenuItemGroupConfiguration;
import net.anwiba.commons.swing.menu.MenuItemGroupDescription;
import net.anwiba.commons.swing.menu.PopupMenuActionItemConfiguration;
import net.anwiba.commons.swing.menu.PopupMenuActionItemDescription;
import net.anwiba.commons.swing.menu.PopupMenuItemButtomFactory;
import net.anwiba.commons.utilities.registry.KeyValueRegistry;

public class PopMenuManager {
    private final KeyValueRegistry<MenuItemGroupDescription, MenuItemGroupConfiguration> registry = new KeyValueRegistry();
    final Comparator<MenuItemGroupDescription> comparator = new MenuItemGroupDescriptionComarator();

    public synchronized void addConfiguration(PopupMenuActionItemConfiguration menuItem) {
        MenuItemGroupDescription menuGroupDescription = ((PopupMenuActionItemDescription)menuItem.getDescription()).getMenuGroupDescription();
        if (!this.registry.contains((Object)menuGroupDescription)) {
            this.registry.register((Object)menuGroupDescription, (Object)new MenuItemGroupConfiguration(menuGroupDescription));
        }
        MenuItemGroupConfiguration groupConfiguration = (MenuItemGroupConfiguration)this.registry.get((Object)menuGroupDescription);
        groupConfiguration.add(menuItem);
    }

    public JPopupMenu getMenu() {
        JPopupMenu menu = new JPopupMenu();
        return this.fillMenu(menu);
    }

    private AbstractButton addToMenu(JPopupMenu menu, AbstractMenuItemConfiguration<?> menuItemConfiguration) {
        PopupMenuItemButtomFactory visitor = new PopupMenuItemButtomFactory(menu, menuItemConfiguration);
        return ((AbstractMenuItemDescription)menuItemConfiguration.getDescription()).getMenuItemType().accept(visitor);
    }

    public boolean isEmpty() {
        return this.registry.isEmpty();
    }

    public JPopupMenu fillMenu(JPopupMenu menu) {
        MenuItemGroupConfiguration[] menuGroups = (MenuItemGroupConfiguration[])this.registry.getItems(this.comparator, MenuItemGroupDescription.class, MenuItemGroupConfiguration.class);
        int i = 0;
        while (i < menuGroups.length) {
            int n;
            if (i > 0) {
                menu.addSeparator();
            }
            AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] menuItemConfigurations = menuGroups[i].getMenuItemConfiguration();
            if (menuGroups[i].getDescription().isToggelGroup()) {
                ButtonGroup group = new ButtonGroup();
                AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] abstractMenuItemConfigurationArray = menuItemConfigurations;
                int n2 = menuItemConfigurations.length;
                n = 0;
                while (n < n2) {
                    AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> menuItemConfiguration = abstractMenuItemConfigurationArray[n];
                    AbstractButton button = this.addToMenu(menu, menuItemConfiguration);
                    group.add(button);
                    ++n;
                }
            } else {
                AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] abstractMenuItemConfigurationArray = menuItemConfigurations;
                n = menuItemConfigurations.length;
                int n3 = 0;
                while (n3 < n) {
                    AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> menuItemConfiguration = abstractMenuItemConfigurationArray[n3];
                    this.addToMenu(menu, menuItemConfiguration);
                    ++n3;
                }
            }
            ++i;
        }
        return menu;
    }

    public JMenu fillMenu(JMenu menu) {
        MenuItemGroupConfiguration[] menuGroups = (MenuItemGroupConfiguration[])this.registry.getItems(this.comparator, MenuItemGroupDescription.class, MenuItemGroupConfiguration.class);
        int i = 0;
        while (i < menuGroups.length) {
            int n;
            if (i > 0) {
                menu.addSeparator();
            }
            AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] menuItemConfigurations = menuGroups[i].getMenuItemConfiguration();
            if (menuGroups[i].getDescription().isToggelGroup()) {
                ButtonGroup group = new ButtonGroup();
                AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] abstractMenuItemConfigurationArray = menuItemConfigurations;
                int n2 = menuItemConfigurations.length;
                n = 0;
                while (n < n2) {
                    AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> menuItemConfiguration = abstractMenuItemConfigurationArray[n];
                    AbstractButton button = this.addToMenu(menu, menuItemConfiguration);
                    group.add(button);
                    ++n;
                }
            } else {
                AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] abstractMenuItemConfigurationArray = menuItemConfigurations;
                n = menuItemConfigurations.length;
                int n3 = 0;
                while (n3 < n) {
                    AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> menuItemConfiguration = abstractMenuItemConfigurationArray[n3];
                    this.addToMenu(menu, menuItemConfiguration);
                    ++n3;
                }
            }
            ++i;
        }
        return menu;
    }

    private AbstractButton addToMenu(JMenu menu, AbstractMenuItemConfiguration<?> menuItemConfiguration) {
        MenuItemButtomFactory visitor = new MenuItemButtomFactory(menu, menuItemConfiguration);
        return ((AbstractMenuItemDescription)menuItemConfiguration.getDescription()).getMenuItemType().accept(visitor);
    }

    public static final class MenuItemGroupDescriptionComarator
    implements Comparator<MenuItemGroupDescription>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(MenuItemGroupDescription o1, MenuItemGroupDescription o2) {
            return Integer.valueOf(o1.getWeight()).compareTo(o2.getWeight());
        }
    }
}

