/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.awt.Color;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectDistributor;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.object.AbstractObjectFieldConfigurationBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.IActionFactory;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.IToolTipFactory;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public abstract class AbstractObjectFieldBuilder<O, C extends AbstractObjectFieldConfigurationBuilder<O, C>, B extends AbstractObjectFieldBuilder<O, C, B>> {
    private final Color INVALID_COLOR = new Color(240, 240, 180);
    private final Color VALID_COLOR = Color.WHITE;
    C builder;

    public AbstractObjectFieldBuilder(C builder) {
        this.builder = builder;
    }

    protected C getConfigurationBuilder() {
        return this.builder;
    }

    public IObjectField<O> build() {
        IObjectFieldConfiguration configuration = ((AbstractObjectFieldConfigurationBuilder)this.builder).build();
        final AbstractObjectTextField field = this.create(configuration);
        final Color validColor = configuration.getBackgroundColor() == null ? this.VALID_COLOR : configuration.getBackgroundColor();
        final IObjectDistributor<IValidationResult> validationResultDistributor = field.getValidationResultDistributor();
        validationResultDistributor.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                GuiUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IValidationResult validationResult = (IValidationResult)validationResultDistributor.get();
                        field.getColorReciever().setBackground(validationResult.isValid() ? validColor : AbstractObjectFieldBuilder.this.INVALID_COLOR);
                    }
                });
            }
        });
        IValidationResult validationResult = (IValidationResult)validationResultDistributor.get();
        if (validationResult != null) {
            field.getColorReciever().setBackground(validationResult.isValid() ? this.VALID_COLOR : this.INVALID_COLOR);
        }
        return field;
    }

    protected abstract AbstractObjectTextField<O> create(IObjectFieldConfiguration<O> var1);

    public B setModel(IObjectModel<O> model) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).setModel(model);
        return (B)this;
    }

    public B setColumns(int columns) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).setColumns(columns);
        return (B)this;
    }

    public B setEditable(boolean isEditable) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).setEditable(isEditable);
        return (B)this;
    }

    public B setToObjectConverter(IConverter<String, O, RuntimeException> toObjectConverter) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).setToObjectConverter(toObjectConverter);
        return (B)this;
    }

    public B setToStringConverter(IConverter<O, String, RuntimeException> toStringConverter) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).setToStringConverter(toStringConverter);
        return (B)this;
    }

    public B setValidator(IValidator<String> validator) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).setValidator(validator);
        return (B)this;
    }

    public B addValidator(IValidator<String> validator) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).addValidator(validator);
        return (B)this;
    }

    public B setNotEmptyValidator(final String message) {
        this.addValidator(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                    return IValidationResult.inValid((String)message);
                }
                return IValidationResult.valid();
            }
        });
        return (B)this;
    }

    public B setValidStateModel(IObjectModel<IValidationResult> validStateModel) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).setValidStateModel(validStateModel);
        return (B)this;
    }

    public B setToolTipFactory(IToolTipFactory factory) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).setToolTipFactory(factory);
        return (B)this;
    }

    public B addClearAction(String tooltip) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).addClearAction(tooltip);
        return (B)this;
    }

    public B addActionFactory(IActionFactory<O> tooltip) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).addActionFactory(tooltip);
        return (B)this;
    }

    public B setBackgroundColor(Color background) {
        ((AbstractObjectFieldConfigurationBuilder)this.builder).setBackgroundColor(background);
        return (B)this;
    }
}

