/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.util.regex.Pattern;
import net.anwiba.commons.swing.object.AbstractObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.DoubleField;
import net.anwiba.commons.swing.object.DoubleObjectFieldConfigurationBuilder;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class DoubleFieldBuilder
extends AbstractObjectFieldBuilder<Double, DoubleObjectFieldConfigurationBuilder, DoubleFieldBuilder> {
    public DoubleFieldBuilder() {
        super(new DoubleObjectFieldConfigurationBuilder());
    }

    @Override
    protected AbstractObjectTextField<Double> create(IObjectFieldConfiguration<Double> configuration) {
        return new DoubleField(configuration);
    }

    public AbstractObjectFieldBuilder<Double, DoubleObjectFieldConfigurationBuilder, DoubleFieldBuilder> setRegularExpressionValidator(final String patternString, final String message) {
        final Pattern pattern = Pattern.compile(patternString);
        ((DoubleObjectFieldConfigurationBuilder)this.getConfigurationBuilder()).setValidator(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                    return IValidationResult.inValid((String)message);
                }
                pattern.matcher(value).matches();
                if (!value.matches(patternString)) {
                    return IValidationResult.inValid((String)message);
                }
                return IValidationResult.valid();
            }
        });
        return this;
    }

    public DoubleFieldBuilder setToolTip(String tooltipText) {
        ((DoubleObjectFieldConfigurationBuilder)this.getConfigurationBuilder()).setToolTipFactory((validationResult, text) -> {
            if (!validationResult.isValid()) {
                return validationResult.getMessage();
            }
            return tooltipText;
        });
        return this;
    }
}

