/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.util.regex.Pattern;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.object.AbstractObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.GenericObjectField;
import net.anwiba.commons.swing.object.GenericObjectFieldConfigurationBuilder;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class GenericObjectFieldBuilder<T>
extends AbstractObjectFieldBuilder<T, GenericObjectFieldConfigurationBuilder<T>, GenericObjectFieldBuilder<T>> {
    public GenericObjectFieldBuilder() {
        super(new GenericObjectFieldConfigurationBuilder(new ObjectModel()));
    }

    @Override
    protected AbstractObjectTextField<T> create(IObjectFieldConfiguration<T> configuration) {
        return new GenericObjectField<T>(configuration);
    }

    @Override
    public GenericObjectFieldBuilder<T> setNotEmptyValidator(final String message) {
        ((GenericObjectFieldConfigurationBuilder)this.getConfigurationBuilder()).setValidator(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                    return IValidationResult.inValid((String)message);
                }
                return IValidationResult.valid();
            }
        });
        return this;
    }

    public GenericObjectFieldBuilder<T> setRegularExpressionValidator(final String patternString, final String message) {
        final Pattern pattern = Pattern.compile(patternString);
        ((GenericObjectFieldConfigurationBuilder)this.getConfigurationBuilder()).setValidator(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                    return IValidationResult.inValid((String)message);
                }
                pattern.matcher(value).matches();
                if (!value.matches(patternString)) {
                    return IValidationResult.inValid((String)message);
                }
                return IValidationResult.valid();
            }
        });
        return this;
    }

    public GenericObjectFieldBuilder<T> setToolTip(String tooltipText) {
        ((GenericObjectFieldConfigurationBuilder)this.getConfigurationBuilder()).setToolTipFactory((validationResult, text) -> {
            if (!validationResult.isValid()) {
                return validationResult.getMessage();
            }
            return tooltipText;
        });
        return this;
    }
}

