/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.util.regex.Pattern;
import net.anwiba.commons.swing.object.AbstractObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.IntegerField;
import net.anwiba.commons.swing.object.IntegerObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class IntegerFieldBuilder
extends AbstractObjectFieldBuilder<Integer, IntegerObjectFieldConfigurationBuilder, IntegerFieldBuilder> {
    public IntegerFieldBuilder() {
        super(new IntegerObjectFieldConfigurationBuilder());
    }

    @Override
    protected AbstractObjectTextField<Integer> create(IObjectFieldConfiguration<Integer> configuration) {
        return new IntegerField(configuration);
    }

    public AbstractObjectFieldBuilder<Integer, IntegerObjectFieldConfigurationBuilder, IntegerFieldBuilder> setRegularExpressionValidator(final String patternString, final String message) {
        final Pattern pattern = Pattern.compile(patternString);
        ((IntegerObjectFieldConfigurationBuilder)this.getConfigurationBuilder()).setValidator(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                    return IValidationResult.inValid((String)message);
                }
                pattern.matcher(value).matches();
                if (!value.matches(patternString)) {
                    return IValidationResult.inValid((String)message);
                }
                return IValidationResult.valid();
            }
        });
        return this;
    }

    public IntegerFieldBuilder setToolTip(String tooltipText) {
        ((IntegerObjectFieldConfigurationBuilder)this.getConfigurationBuilder()).setToolTipFactory((validationResult, text) -> {
            if (!validationResult.isValid()) {
                return validationResult.getMessage();
            }
            return tooltipText;
        });
        return this;
    }
}

