/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preference;

import java.awt.Rectangle;
import net.anwiba.commons.preferences.DummyPreferences;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.preference.BooleanPreference;

public class BoundsPreference {
    private static final String HEIGHT = "HEIGHT";
    private static final String WIDTH = "WIDTH";
    private static final String Y = "Y";
    private static final String X = "X";
    private final IPreferences preferences;
    public static final String NAME = "bounds";
    private static final String IS_PREFERENCE_ENABLED = "isEnabled";
    private final BooleanPreference enabledPreference;

    public BoundsPreference(IPreferences preferences) {
        this.preferences = preferences == null ? new DummyPreferences(new String[0]) : preferences;
        this.enabledPreference = new BooleanPreference(preferences, IS_PREFERENCE_ENABLED);
    }

    public Rectangle getRectangle() {
        if (!this.enabledPreference.isTrue()) {
            return null;
        }
        int x = this.preferences.getInt(X, -1);
        if (x == -1) {
            return null;
        }
        int y = this.preferences.getInt(Y, -1);
        if (y == -1) {
            return null;
        }
        int width = this.preferences.getInt(WIDTH, -1);
        if (width == -1) {
            return null;
        }
        int height = this.preferences.getInt(HEIGHT, -1);
        if (height == -1) {
            return null;
        }
        return new Rectangle(x, y, width, height);
    }

    public void setRectangle(Rectangle bounds) {
        if (bounds == null || !this.enabledPreference.isTrue()) {
            return;
        }
        this.preferences.setInt(X, bounds.x);
        this.preferences.setInt(Y, bounds.y);
        this.preferences.setInt(WIDTH, bounds.width);
        this.preferences.setInt(HEIGHT, bounds.height);
        this.enabledPreference.setValue(true);
        this.preferences.flush();
    }
}

