/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preference;

import net.anwiba.commons.preferences.DummyPreferences;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.preference.BooleanPreference;

public class SplitPanePreferences {
    public static final String NAME = "splitPane";
    private static final String DIVIDER_LOCATION = "dividerLocation";
    private static final String IS_PREFERENCE_ENABLED = "isEnabled";
    private final BooleanPreference enabledPreference;
    private final IPreferences preferences;

    public SplitPanePreferences(IPreferences preferences) {
        this.preferences = preferences == null ? new DummyPreferences(new String[0]) : preferences;
        this.enabledPreference = new BooleanPreference(preferences, IS_PREFERENCE_ENABLED);
    }

    public void setDividerLocation(int dividerLocation) {
        if (Integer.MIN_VALUE == dividerLocation || Integer.MAX_VALUE == dividerLocation || !this.enabledPreference.isTrue()) {
            return;
        }
        this.preferences.setInt(DIVIDER_LOCATION, dividerLocation);
        this.enabledPreference.setValue(true);
        this.preferences.flush();
    }

    public int getDividerLocation(int dividerLocation) {
        if (!this.enabledPreference.isTrue()) {
            return dividerLocation;
        }
        return this.preferences.getInt(DIVIDER_LOCATION, dividerLocation);
    }
}

