/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preference;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.anwiba.commons.swing.preference.IWindowPreferences;

public final class WindowPrefereneceUpdatingListener
extends WindowAdapter
implements ComponentListener {
    private final Window window;
    private final IWindowPreferences preferences;
    private boolean isVisible = false;
    private Rectangle rectangle = new Rectangle();

    public WindowPrefereneceUpdatingListener(Window window, IWindowPreferences windowPreferences) {
        this.window = window;
        this.preferences = windowPreferences;
    }

    @Override
    public synchronized void componentResized(ComponentEvent e) {
        this.update();
    }

    @Override
    public synchronized void componentMoved(ComponentEvent e) {
        this.update();
    }

    private void update() {
        if (!this.isVisible || this.window.getBounds().equals(this.rectangle)) {
            return;
        }
        if (this.window instanceof Frame && ((Frame)this.window).getState() != 0) {
            return;
        }
        this.rectangle = this.window.getBounds();
        this.preferences.setBounds(this.rectangle);
    }

    @Override
    public synchronized void componentShown(ComponentEvent e) {
        this.rectangle = this.window.getBounds();
        this.isVisible = true;
    }

    @Override
    public synchronized void componentHidden(ComponentEvent e) {
        this.isVisible = false;
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.window.removeComponentListener(this);
        this.window.removeWindowListener(this);
    }
}

