/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.ISelectionIndexModel;
import net.anwiba.commons.utilities.collection.IterableUtilities;

public final class RemoveTableRowAction<T>
extends AbstractAction {
    private final ISelectionIndexModel<T> selectionIndexModel;
    private final IObjectTableModel<T> tableModel;

    public RemoveTableRowAction(String name, Icon icon, String tooltipText, ISelectionIndexModel<T> selectionIndexModel, IObjectTableModel<T> tableModel) {
        super(name, icon);
        this.putValue("ShortDescription", tooltipText);
        this.selectionIndexModel = selectionIndexModel;
        this.tableModel = tableModel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.selectionIndexModel.isEmpty()) {
            return;
        }
        ArrayList<Integer> indeces = new ArrayList<Integer>();
        for (Integer index : this.selectionIndexModel) {
            indeces.add(index);
        }
        this.tableModel.remove(IterableUtilities.toPrimativArray(indeces));
        this.selectionIndexModel.clear();
    }
}

