/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.listener;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ListSelectionModel;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.ISortedRowMapper;
import net.anwiba.commons.utilities.collection.IterableUtilities;

public final class SelectionListener<T>
implements ISelectionListener<T> {
    private final IObjectTableModel<T> tableModel;
    private final ListSelectionModel tableSelectionModel;
    private final ISelectionModel<T> objectSelectionModel;
    private final ISortedRowMapper sortedRowMapper;

    public SelectionListener(IObjectTableModel<T> tableModel, ListSelectionModel tableSelectionModel, ISelectionModel<T> objectSelectionModel, ISortedRowMapper sortedRowMapper) {
        this.tableModel = tableModel;
        this.tableSelectionModel = tableSelectionModel;
        this.objectSelectionModel = objectSelectionModel;
        this.sortedRowMapper = sortedRowMapper;
    }

    public void selectionChanged(SelectionEvent<T> event) {
        int[] indexes;
        if (this.objectSelectionModel.isEmpty() && this.tableSelectionModel.isSelectionEmpty()) {
            return;
        }
        if (this.objectSelectionModel.isEmpty()) {
            this.tableSelectionModel.clearSelection();
            return;
        }
        List<T> objects = this.getObjects(this.tableModel, this.tableSelectionModel);
        List selectedObjects = IterableUtilities.asList((Iterable)this.objectSelectionModel.getSelectedObjects());
        if (objects.size() == this.objectSelectionModel.size() && objects.containsAll(selectedObjects)) {
            return;
        }
        this.tableSelectionModel.setValueIsAdjusting(true);
        this.tableSelectionModel.clearSelection();
        int[] nArray = indexes = this.tableModel.indices(selectedObjects);
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            int row = this.sortedRowMapper.getSortedRow(index);
            this.tableSelectionModel.addSelectionInterval(row, row);
            ++n2;
        }
        this.tableSelectionModel.setValueIsAdjusting(false);
    }

    private List<T> getObjects(IObjectTableModel<T> tableModel, ListSelectionModel tableSelectionModel) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (tableSelectionModel.isSelectionEmpty()) {
            return objects;
        }
        int i = tableSelectionModel.getMinSelectionIndex();
        while (i <= tableSelectionModel.getMaxSelectionIndex()) {
            if (tableSelectionModel.isSelectedIndex(i)) {
                objects.add(tableModel.get(this.sortedRowMapper.getModelIndex(i)));
            }
            ++i;
        }
        return objects;
    }
}

