/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.toolbar;

import java.io.Serializable;
import java.util.Comparator;
import net.anwiba.commons.swing.toolbar.ToolBarItemConfiguration;
import net.anwiba.commons.swing.toolbar.ToolBarItemDescription;
import net.anwiba.commons.swing.toolbar.ToolBarItemGroupDescription;
import net.anwiba.commons.utilities.registry.KeyValueRegistry;

public class ToolBarItemGroupConfiguration {
    private final ToolBarItemGroupDescription description;
    private final KeyValueRegistry<ToolBarItemDescription, ToolBarItemConfiguration> registry = new KeyValueRegistry();
    final Comparator<ToolBarItemDescription> comparator = new ToolBarItemDescriptionComparator();

    public ToolBarItemGroupConfiguration(ToolBarItemGroupDescription toolBarGroupDescription) {
        this.description = toolBarGroupDescription;
    }

    public ToolBarItemGroupDescription getDescription() {
        return this.description;
    }

    public void add(ToolBarItemConfiguration toolBarItem) {
        this.registry.register((Object)((ToolBarItemDescription)toolBarItem.getDescription()), (Object)toolBarItem);
    }

    public void remove(ToolBarItemConfiguration toolBarItem) {
        this.registry.remove((Object)((ToolBarItemDescription)toolBarItem.getDescription()));
    }

    public ToolBarItemConfiguration[] getToolBarItemConfigurations() {
        return (ToolBarItemConfiguration[])this.registry.getItems(this.comparator, ToolBarItemDescription.class, ToolBarItemConfiguration.class);
    }

    public boolean isEmpty() {
        return this.registry.isEmpty();
    }

    public static final class ToolBarItemDescriptionComparator
    implements Comparator<ToolBarItemDescription>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(ToolBarItemDescription o1, ToolBarItemDescription o2) {
            return Integer.valueOf(o1.getWeight()).compareTo(o2.getWeight());
        }
    }
}

