/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import net.anwiba.commons.lang.object.IObjectReceiver;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.tree.ITreeModel;
import net.anwiba.commons.swing.tree.ITreeNode;
import net.anwiba.commons.swing.tree.ITreeNodeFilter;
import net.anwiba.commons.swing.tree.NeutralTreeNodeFilter;

public class FilteredTreeModel<T extends ITreeNode>
implements ITreeModel<T> {
    private final NeutralTreeNodeFilter<T> neutralTreeNodeFilter = new NeutralTreeNodeFilter();
    private final IObjectModel<ITreeNodeFilter<T>> filterModel = new ObjectModel(this.neutralTreeNodeFilter);
    private final T rootNode;
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

    public FilteredTreeModel(T rootNode) {
        this.rootNode = rootNode;
        this.filterModel.addChangeListener(new IChangeableObjectListener((ITreeNode)rootNode){
            private final /* synthetic */ ITreeNode val$rootNode;
            {
                this.val$rootNode = iTreeNode;
            }

            public void objectChanged() {
                FilteredTreeModel.this.fireTreeStructureChanged(this.val$rootNode);
            }
        });
    }

    @Override
    public T getRoot() {
        return this.rootNode;
    }

    @Override
    public T getChild(Object parent, int index) {
        return (T)this.getFilter().getChild((ITreeNode)parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.getFilter().getChildCount((ITreeNode)parent);
    }

    private ITreeNodeFilter<T> getFilter() {
        NeutralTreeNodeFilter<T> object = (NeutralTreeNodeFilter<T>)this.filterModel.get();
        return object == null ? this.neutralTreeNodeFilter : object;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((ITreeNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.getFilter().getIndexOfChild((ITreeNode)parent, (ITreeNode)child);
    }

    public IObjectReceiver<ITreeNodeFilter<T>> getFilterReceiver() {
        return this.filterModel;
    }

    protected synchronized void fireTreeStructureChanged(T rootNode) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(rootNode));
        ArrayList<TreeModelListener> currentListeners = new ArrayList<TreeModelListener>(this.listeners);
        for (TreeModelListener listener : currentListeners) {
            listener.treeStructureChanged(treeModelEvent);
        }
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }
}

