/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.utilities;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class JTextComponentUtilities {
    private static ILogger logger = Logging.getLogger((String)JTextComponentUtilities.class.getName());

    public static void setTextAndMoveToTop(JTextComponent textPane, String text) {
        GuiUtilities.invokeLater(new SetTextRunnable(text, textPane));
    }

    public static void setTextAndMoveToTop(final Document document, final String text) {
        GuiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).replace(0, document.getLength(), text, null);
                        return;
                    }
                    document.remove(0, document.getLength());
                    document.insertString(0, text, null);
                }
                catch (BadLocationException exception) {
                    logger.log(ILevel.FATAL, exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        });
    }

    public static double getValueWidth(Component component, String value) {
        Font font = component.getFont();
        FontRenderContext fontRenderContext = component.getFontMetrics(font).getFontRenderContext();
        return font.getStringBounds(value, fontRenderContext).getWidth();
    }

    public static double getValueWidth(Graphics graphics, String value) {
        Font font = graphics.getFont();
        FontRenderContext fontRenderContext = graphics.getFontMetrics(font).getFontRenderContext();
        return font.getStringBounds(value, fontRenderContext).getWidth();
    }

    static final class SetTextRunnable
    implements Runnable {
        private final String text;
        private final JTextComponent textPane;

        SetTextRunnable(String text, JTextComponent textPane) {
            this.text = text;
            this.textPane = textPane;
        }

        @Override
        public void run() {
            this.textPane.setText(this.text);
            this.textPane.setCaretPosition(0);
        }
    }
}

