/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.utilities;

import java.awt.Component;
import java.awt.Container;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;

public class SpringLayoutUtilities {
    public static void makeGrid(Container parent, int cols, int rows, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout.Constraints cons;
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("The first argument to makeGrid must use SpringLayout.");
        }
        Spring xPadSpring = Spring.constant(xPad);
        Spring yPadSpring = Spring.constant(yPad);
        Spring initialXSpring = Spring.constant(initialX);
        Spring initialYSpring = Spring.constant(initialY);
        int max = rows * cols;
        Spring maxWidthSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        Spring maxHeightSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        int i = 1;
        while (i < max) {
            cons = layout.getConstraints(parent.getComponent(i));
            maxWidthSpring = Spring.max(maxWidthSpring, cons.getWidth());
            maxHeightSpring = Spring.max(maxHeightSpring, cons.getHeight());
            ++i;
        }
        i = 0;
        while (i < max) {
            cons = layout.getConstraints(parent.getComponent(i));
            cons.setWidth(maxWidthSpring);
            cons.setHeight(maxHeightSpring);
            ++i;
        }
        SpringLayout.Constraints lastCons = null;
        SpringLayout.Constraints lastRowCons = null;
        int i2 = 0;
        while (i2 < max) {
            SpringLayout.Constraints cons2 = layout.getConstraints(parent.getComponent(i2));
            if (i2 % cols == 0) {
                lastRowCons = lastCons;
                cons2.setX(initialXSpring);
            } else if (lastCons != null) {
                cons2.setX(Spring.sum(lastCons.getConstraint("East"), xPadSpring));
            } else {
                throw new UnreachableCodeReachedException();
            }
            if (i2 / cols == 0) {
                cons2.setY(initialYSpring);
            } else if (lastRowCons != null) {
                cons2.setY(Spring.sum(lastRowCons.getConstraint("South"), yPadSpring));
            } else {
                throw new UnreachableCodeReachedException();
            }
            lastCons = cons2;
            ++i2;
        }
        if (lastCons == null) {
            throw new UnreachableCodeReachedException();
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", Spring.sum(Spring.constant(initialX), lastCons.getConstraint("South")));
        pCons.setConstraint("East", Spring.sum(Spring.constant(initialY), lastCons.getConstraint("East")));
    }

    private static SpringLayout.Constraints getConstraintsForCell(int col, int row, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static void makeCompactGrid(Container parent, int cols, int rows, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("The first argument to makeCompactGrid must use SpringLayout.");
        }
        Spring x = Spring.constant(initialX);
        int c = 0;
        while (c < cols) {
            Spring width = Spring.constant(0);
            int r = 0;
            while (r < rows) {
                width = Spring.max(width, SpringLayoutUtilities.getConstraintsForCell(c, r, parent, cols).getWidth());
                ++r;
            }
            r = 0;
            while (r < rows) {
                SpringLayout.Constraints constraints = SpringLayoutUtilities.getConstraintsForCell(c, r, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
                ++r;
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
            ++c;
        }
        x = Spring.sum(x, Spring.sum(Spring.constant(-xPad), Spring.constant(initialX)));
        Spring y = Spring.constant(initialY);
        int row = 0;
        while (row < rows) {
            Spring height = Spring.constant(0);
            int c2 = 0;
            while (c2 < cols) {
                height = Spring.max(height, SpringLayoutUtilities.getConstraintsForCell(c2, row, parent, cols).getHeight());
                ++c2;
            }
            int col = 0;
            while (col < cols) {
                SpringLayout.Constraints constraints = SpringLayoutUtilities.getConstraintsForCell(col, row, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
                ++col;
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
            ++row;
        }
        y = Spring.sum(y, Spring.sum(Spring.constant(-yPad), Spring.constant(initialY)));
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }
}

