/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.frame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import net.anwiba.commons.swing.frame.IKeyActionConfiguration;
import net.anwiba.commons.swing.frame.KeyActionManager;
import net.anwiba.commons.swing.frame.view.IView;
import net.anwiba.commons.swing.frame.view.ViewManager;
import net.anwiba.commons.swing.menu.MenuManager;
import net.anwiba.commons.swing.statebar.StateBarManager;
import net.anwiba.commons.swing.toolbar.ToolBarManager;

public class ApplicationFrame
extends JFrame {
    private final JPanel contentPane = new JPanel();
    private final JPanel toolBar = new JPanel();
    private final JPanel viewPane = new JPanel();
    private final JPanel buttomPane = new JPanel();
    private final JPanel functionPane = new JPanel();
    private final JPanel stateBar = new JPanel();
    private final MenuManager menuManager;
    private final ToolBarManager toolBarManager;
    private final StateBarManager stateBarManager;
    private final ViewManager viewManager;
    private IView view;
    private final KeyActionManager keyActionManager;

    public ApplicationFrame(MenuManager menuManager, ToolBarManager toolBarManager, ViewManager viewManager, StateBarManager stateBarManager, KeyActionManager keyActionManager) {
        this.menuManager = menuManager;
        this.toolBarManager = toolBarManager;
        this.viewManager = viewManager;
        this.stateBarManager = stateBarManager;
        this.keyActionManager = keyActionManager;
        this.contentPane.setLayout(new BorderLayout());
        this.toolBar.setLayout(new FlowLayout(0, 0, 0));
        this.viewPane.setLayout(new GridLayout(1, 1));
        this.stateBar.setMinimumSize(new Dimension(28, 30));
        this.buttomPane.setLayout(new BorderLayout());
        this.stateBar.setLayout(new GridLayout(1, 1));
        this.stateBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.functionPane.setLayout(new GridLayout(1, 1));
        this.buttomPane.add((Component)this.functionPane, "Center");
        this.buttomPane.add((Component)this.stateBar, "South");
        this.contentPane.add((Component)this.toolBar, "North");
        this.contentPane.add((Component)this.viewPane, "Center");
        this.contentPane.add((Component)this.buttomPane, "South");
        this.setContentPane(this.contentPane);
    }

    public void initialize() {
        this.view = this.viewManager.getCurrentView();
        this.menuManager.add(this.view.getMenuItemConfigurations());
        this.resetMenuBar();
        this.toolBarManager.add(this.view.getToolBarItemConfigurations());
        this.resetToolBar();
        this.viewPane.add(this.view.getComponent());
        this.viewPane.revalidate();
        this.stateBarManager.add(this.view.getStateBarComponentConfigurations());
        this.resetStateBar();
        this.keyActionManager.add(this.view.getKeyActionConfigurations());
        for (IKeyActionConfiguration configuration : this.keyActionManager.configurations()) {
            this.addKeyAction(configuration);
        }
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public ToolBarManager getToolBarManager() {
        return this.toolBarManager;
    }

    public ViewManager getViewManager() {
        return this.viewManager;
    }

    public StateBarManager getStateBarManager() {
        return this.stateBarManager;
    }

    public KeyActionManager getKeyActionManager() {
        return this.keyActionManager;
    }

    public void setFunctionPane(Component component) {
        this.functionPane.removeAll();
        if (component == null) {
            return;
        }
        this.functionPane.add(component);
    }

    private void addKeyAction(IKeyActionConfiguration configuration) {
        this.getLayeredPane().getInputMap(2).put(configuration.getKeyStroke(), configuration.getActionKey());
        this.getLayeredPane().getActionMap().put(configuration.getActionKey(), configuration.getAction());
    }

    private void resetStateBar() {
        this.stateBar.removeAll();
        this.stateBar.add(this.stateBarManager.getStateBar());
        this.stateBar.revalidate();
    }

    private synchronized void resetMenuBar() {
        this.setJMenuBar(this.menuManager.getMenuBar());
    }

    private synchronized void resetToolBar() {
        JToolBar[] toolBars = this.toolBarManager.getJToolBars();
        this.toolBar.removeAll();
        JToolBar[] jToolBarArray = toolBars;
        int n = toolBars.length;
        int n2 = 0;
        while (n2 < n) {
            JToolBar toolBar = jToolBarArray[n2];
            this.toolBar.add(toolBar);
            ++n2;
        }
        this.toolBar.revalidate();
    }
}

