/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.filechooser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.filechooser.IFileChooserPanel;

public final class MultiFileChooserPanel
implements IFileChooserPanel {
    private final JFileChooser fileChooser;
    private final IPreferences preferences;
    private final IObjectModel<File[]> model = new ObjectModel();

    public MultiFileChooserPanel(JFileChooser fileChooser, IPreferences preferences) {
        this.fileChooser = fileChooser;
        this.preferences = preferences;
        fileChooser.addPropertyChangeListener("SelectedFilesChangedProperty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                File[] files = (File[])event.getNewValue();
                MultiFileChooserPanel.this.getModel().set((Object)files);
            }
        });
    }

    @Override
    public JComponent getComponent() {
        return this.fileChooser;
    }

    @Override
    public void savePreferences() {
        File currentDirectory = this.fileChooser.getCurrentDirectory();
        this.preferences.put("folder", currentDirectory.getAbsolutePath());
    }

    public IObjectModel<File[]> getModel() {
        return this.model;
    }
}

