/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableRowSorter;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.swing.table.IObjectTableModel;

public class ObjectTableRowSorter<T>
extends TableRowSorter<IObjectTableModel<T>> {
    private final BooleanModel sortStateModel = new BooleanModel(false);

    public ObjectTableRowSorter(IObjectTableModel<T> tableModel) {
        super(tableModel);
    }

    private void checkColumn(int column) {
        if (column < 0 || column >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
    }

    @Override
    public void toggleSortOrder(int column) {
        this.checkColumn(column);
        if (this.isSortable(column)) {
            List<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
            int sortIndex = keys.size() - 1;
            while (sortIndex >= 0) {
                if (((RowSorter.SortKey)keys.get(sortIndex)).getColumn() == column) break;
                --sortIndex;
            }
            if (sortIndex == -1) {
                RowSorter.SortKey sortKey = new RowSorter.SortKey(column, SortOrder.ASCENDING);
                keys.add(0, sortKey);
            } else if (sortIndex == 0) {
                keys.set(0, this.toggle((RowSorter.SortKey)keys.get(0)));
            } else {
                keys.remove(sortIndex);
                keys.add(0, new RowSorter.SortKey(column, SortOrder.ASCENDING));
            }
            if (keys.size() > this.getMaxSortKeys()) {
                keys = keys.subList(0, this.getMaxSortKeys());
            }
            this.setSortKeys(keys);
            this.checkSortState();
        }
    }

    private void checkSortState() {
        boolean state = false;
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        for (RowSorter.SortKey sortKey : keys) {
            state |= !sortKey.getSortOrder().equals((Object)SortOrder.UNSORTED);
        }
        this.sortStateModel.set(state);
    }

    private RowSorter.SortKey toggle(RowSorter.SortKey key) {
        switch (key.getSortOrder()) {
            case ASCENDING: {
                return new RowSorter.SortKey(key.getColumn(), SortOrder.DESCENDING);
            }
            case DESCENDING: {
                return new RowSorter.SortKey(key.getColumn(), SortOrder.UNSORTED);
            }
            case UNSORTED: {
                return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
            }
        }
        throw new UnreachableCodeReachedException();
    }

    public IBooleanDistributor getSortStateModel() {
        return this.sortStateModel;
    }
}

