/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.util.Iterator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.ListenerList;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.model.SelectionModel;
import net.anwiba.commons.swing.table.ISelectionIndexModel;
import net.anwiba.commons.swing.table.ISortedRowMapper;
import net.anwiba.commons.utilities.interval.IntegerInterval;
import net.anwiba.commons.utilities.interval.IntegerIterator;

public final class SelectionIndexModel<T>
implements ISelectionIndexModel<T> {
    private final ListSelectionModel tableSelectionModel;
    private final ISortedRowMapper rowMapper;
    private final SelectionModel<T> selectionModel;
    private final ListenerList<ISelectionListener<T>> listeners = new ListenerList();

    public SelectionIndexModel(ListSelectionModel tableSelectionModel, ISortedRowMapper rowMapper, SelectionModel<T> selectionModel) {
        this.tableSelectionModel = tableSelectionModel;
        this.rowMapper = rowMapper;
        this.selectionModel = selectionModel;
        selectionModel.addSelectionListener(new ISelectionListener<T>(){

            public void selectionChanged(SelectionEvent<T> event) {
                SelectionIndexModel.this.fireSelectionChanged();
            }
        });
        tableSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                SelectionIndexModel.this.fireSelectionChanged();
            }
        });
    }

    public IntegerInterval getInterval() {
        int minimum = this.tableSelectionModel.getMinSelectionIndex();
        int maximum = this.tableSelectionModel.getMaxSelectionIndex();
        if (minimum < 0 || maximum < 0) {
            return new IntegerInterval(-1, -1);
        }
        return new IntegerInterval(this.rowMapper.getModelIndex(minimum), this.rowMapper.getModelIndex(maximum));
    }

    @Override
    public int getMinimum() {
        return this.getInterval().getMinValue();
    }

    @Override
    public int getMaximum() {
        return this.getInterval().getMaxValue();
    }

    @Override
    public void set(int index) {
        this.tableSelectionModel.setSelectionInterval(this.rowMapper.getSortedRow(index), this.rowMapper.getSortedRow(index));
    }

    @Override
    public Iterator<Integer> iterator() {
        final ISortedRowMapper rowMapper = this.rowMapper;
        final ListSelectionModel tableSelectionModel = this.tableSelectionModel;
        final IntegerIterator integerIterator = new IntegerIterator(tableSelectionModel.getMinSelectionIndex(), tableSelectionModel.getMaxSelectionIndex(), (IAcceptor)new IAcceptor<Integer>(){

            public boolean accept(Integer value) {
                return tableSelectionModel.isSelectedIndex(value);
            }
        });
        return new Iterator<Integer>(){
            private Integer value = null;

            @Override
            public boolean hasNext() {
                if (this.value != null) {
                    return true;
                }
                if (integerIterator.hasNext()) {
                    this.value = rowMapper.getModelIndex(integerIterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public Integer next() {
                try {
                    Integer n = this.value;
                    return n;
                }
                finally {
                    this.value = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    void fireSelectionChanged() {
        final SelectionModel<T> model = this.selectionModel;
        this.listeners.forAllDo(new IProcedure<ISelectionListener<T>, RuntimeException>(){

            public void execute(ISelectionListener<T> value) throws RuntimeException {
                value.selectionChanged(new SelectionEvent(model));
            }
        });
    }

    @Override
    public int size() {
        return this.selectionModel.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tableSelectionModel.isSelectionEmpty();
    }

    @Override
    public void addSelectionListener(ISelectionListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSelectionListener(ISelectionListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clear() {
        this.selectionModel.removeAllSelectedObjects();
    }
}

