/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.utilities;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class JTreeUtilities {
    public static void expandAll(final JTree tree, final DefaultMutableTreeNode node) {
        GuiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTreeUtilities.internalExpandAll(tree, node);
            }
        });
    }

    static void internalExpandAll(JTree tree, DefaultMutableTreeNode node) {
        tree.expandPath(new TreePath(node.getPath()));
        int i = 0;
        while (i < node.getChildCount()) {
            JTreeUtilities.expandAll(tree, (DefaultMutableTreeNode)node.getChildAt(i));
            ++i;
        }
    }

    public static void expandAll(final JTree tree) {
        GuiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTreeUtilities.internalExpandAll(tree);
            }
        });
    }

    static void internalExpandAll(JTree tree) {
        int row = 0;
        while (row < tree.getRowCount()) {
            tree.expandRow(row);
            ++row;
        }
    }

    public static void collapseAll(final JTree tree) {
        GuiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTreeUtilities.internalCollapseAll(tree);
            }
        });
    }

    static void internalCollapseAll(JTree tree) {
        int row = tree.getRowCount() - 1;
        while (row >= 0) {
            tree.collapseRow(row);
            --row;
        }
    }

    public static void selectFirstLeaf(JTree tree, DefaultMutableTreeNode node) {
        if (node.getChildCount() == 0) {
            return;
        }
        TreePath treePath = new TreePath(node.getFirstLeaf().getPath());
        JTreeUtilities.selectPath(tree, treePath);
    }

    private static void selectPath(JTree tree, TreePath treePath) {
        tree.getSelectionModel().setSelectionPath(treePath);
        tree.scrollPathToVisible(treePath);
    }

    public static void selectFirstNode(JTree tree, DefaultMutableTreeNode node) {
        if (node.getChildCount() == 0) {
            return;
        }
        TreeNode childNode = node.getFirstChild();
        if (childNode instanceof DefaultMutableTreeNode) {
            TreePath treePath = new TreePath(((DefaultMutableTreeNode)childNode).getPath());
            JTreeUtilities.selectPath(tree, treePath);
        }
    }

    public static void insertNode(final DefaultTreeModel model, final JTree tree, final DefaultMutableTreeNode root, final DefaultMutableTreeNode node, final int index) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JTreeUtilities.internalInsertNode(model, tree, root, node, index);
            }
        };
        GuiUtilities.invokeLater(runnable);
    }

    static void internalInsertNode(DefaultTreeModel model, JTree tree, DefaultMutableTreeNode root, DefaultMutableTreeNode node, int index) {
        model.insertNodeInto(node, root, index);
        TreePath treePath = new TreePath(node.getPath());
        tree.getSelectionModel().setSelectionPath(treePath);
        tree.scrollPathToVisible(treePath);
    }

    public static void collapse(JTree tree, DefaultMutableTreeNode node) {
    }
}

