/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.swing.action.AbstractCustomizedAction;
import net.anwiba.commons.swing.action.IActionConfiguration;
import net.anwiba.commons.swing.action.IActionProcedure;
import net.anwiba.commons.swing.dialog.MessageDialogLauncher;

public class ConfigurableAction
extends AbstractCustomizedAction {
    private static ILogger logger = Logging.getLogger((String)ConfigurableAction.class.getName());
    private final IActionProcedure closure;
    private final IActionConfiguration configuration;

    public ConfigurableAction(final IActionConfiguration configuration) {
        super(configuration.getCustomization());
        this.configuration = configuration;
        configuration.getEnabledModel().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                ConfigurableAction.super.setEnabled(configuration.getEnabledModel().get());
            }
        });
        super.setEnabled(configuration.getEnabledModel().get());
        this.closure = configuration.getProcedure();
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.configuration.getEnabledModel().set(newValue);
    }

    @Override
    protected void execute(Component componment, ActionEvent event) {
        try {
            this.closure.execute(componment);
        }
        catch (Exception exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            new MessageDialogLauncher().text(exception.getMessage()).error().throwable(exception).launch(componment);
        }
    }
}

