/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.swing.component.IComponentAdder;

public class ComponentBuilder
implements IComponentAdder {
    private Dimension size = new Dimension();
    private Dimension preferredSize = null;
    private Dimension minimumSize = null;
    private Dimension maximumSize = null;
    private Border border = null;
    private Color backGroundColor = null;
    private LayoutManager layoutManager = null;
    private final List<ObjectPair<Component, Object>> components = new ArrayList<ObjectPair<Component, Object>>();
    private boolean isOptimizedDrawingEnabled = true;

    private void reset() {
        this.size = new Dimension();
        this.minimumSize = null;
        this.maximumSize = null;
        this.preferredSize = null;
        this.border = null;
        this.backGroundColor = null;
        this.layoutManager = null;
        this.components.clear();
        this.isOptimizedDrawingEnabled = true;
    }

    @Override
    public ComponentBuilder add(Component component) {
        this.components.add((ObjectPair<Component, Object>)new ObjectPair((Object)component, null));
        return this;
    }

    @Override
    public ComponentBuilder add(Component component, Object constaints) {
        this.components.add((ObjectPair<Component, Object>)new ObjectPair((Object)component, constaints));
        return this;
    }

    public ComponentBuilder setSize(int width, int height) {
        this.size = new Dimension(width, height);
        return this;
    }

    public ComponentBuilder setEmptyBorder() {
        this.border = BorderFactory.createEmptyBorder();
        return this;
    }

    public ComponentBuilder setLineBorder(Color color, int width) {
        this.border = BorderFactory.createLineBorder(color, width);
        return this;
    }

    public ComponentBuilder setMinimumSize(int width, int height) {
        this.minimumSize = new Dimension(width, height);
        return this;
    }

    public ComponentBuilder setMaximumSize(int width, int height) {
        this.maximumSize = new Dimension(width, height);
        return this;
    }

    public ComponentBuilder setPreferredSize(int width, int height) {
        this.preferredSize = new Dimension(width, height);
        return this;
    }

    public ComponentBuilder setBackGroundColor(Color backGroundColor) {
        this.backGroundColor = backGroundColor;
        return this;
    }

    public ComponentBuilder setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        return this;
    }

    public JComponent build() {
        JPanel panel = this.isOptimizedDrawingEnabled ? new JPanel() : new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        panel.setSize(this.size);
        panel.setMinimumSize(this.minimumSize);
        panel.setMaximumSize(this.maximumSize);
        panel.setPreferredSize(this.preferredSize);
        panel.setBorder(this.border);
        if (this.backGroundColor != null) {
            panel.setBackground(this.backGroundColor);
        }
        if (this.layoutManager != null) {
            panel.setLayout(this.layoutManager);
        }
        if (this.layoutManager == null && this.components.size() == 1) {
            panel.setLayout(new GridLayout(1, 1));
        }
        for (ObjectPair<Component, Object> pair : this.components) {
            panel.add((Component)pair.getFirstObject(), pair.getSecondObject());
        }
        this.reset();
        return panel;
    }

    public ComponentBuilder setOptimizedDrawing(boolean isOptimizedDrawingEnabled) {
        this.isOptimizedDrawingEnabled = isOptimizedDrawingEnabled;
        return this;
    }
}

