/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.ImageFileFilter;
import net.anwiba.commons.image.ImageReaderUtilities;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.process.cancel.Canceler;
import net.anwiba.commons.process.cancel.ICanceler;
import net.anwiba.commons.resource.reference.IResourceReference;
import net.anwiba.commons.resource.reference.IResourceReferenceHandler;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class ImagePanel
extends JComponent {
    private IImageContainer imageContainer = null;
    private BufferedImage thumbnail = null;
    private Thread thread = null;
    private final IResourceReferenceHandler resourceReferenceHandler;

    public ImagePanel(IResourceReferenceHandler resourceReferenceHandler, final IObjectModel<IResourceReference> imageFileModel) {
        this.resourceReferenceHandler = resourceReferenceHandler;
        final ImageFileFilter fileFilter = new ImageFileFilter();
        this.setPreferredSize(new Dimension(100, 100));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        imageFileModel.addChangeListener(() -> {
            this.reset();
            this.load(imageFileModel, fileFilter);
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                ImagePanel.this.load((IObjectModel<IResourceReference>)imageFileModel, fileFilter);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ImagePanel.this.load((IObjectModel<IResourceReference>)imageFileModel, fileFilter);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ImagePanel.this.reset();
            }
        });
    }

    protected void load(IObjectModel<IResourceReference> imageFileModel, ImageFileFilter fileFilter) {
        IResourceReference imageFile = (IResourceReference)imageFileModel.get();
        if (this.isAccepted(fileFilter, imageFile)) {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = new Thread(() -> {
                try {
                    if (this.loadImage(imageFile)) {
                        GuiUtilities.invokeLater(() -> this.repaint());
                    }
                }
                catch (IOException iOException) {}
            });
            this.thread.start();
        }
    }

    private boolean isAccepted(ImageFileFilter fileFilter, IResourceReference imageFile) {
        try {
            if (this.resourceReferenceHandler.isFileSystemResource(imageFile)) {
                File file = this.resourceReferenceHandler.getFile(imageFile);
                return file != null && file.isFile() && fileFilter.accept(file);
            }
            return imageFile != null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    protected void reset() {
        if (this.imageContainer != null) {
            this.imageContainer.dispose();
        }
        this.imageContainer = null;
        this.thumbnail = null;
        GuiUtilities.invokeLater(() -> this.repaint());
    }

    protected synchronized boolean loadImage(IResourceReference imageFile) throws IOException {
        if (this.imageContainer == null) {
            IImageContainer container;
            block5: {
                try {
                    container = ImageReaderUtilities.read((ICanceler)Canceler.DummyCancler, (IResourceReference)imageFile);
                    if (container != null) break block5;
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            this.imageContainer = container;
        }
        Rectangle bound = this.imageBound();
        if (this.thumbnail != null && this.thumbnail.getWidth() == bound.width && this.thumbnail.getHeight() == bound.height) {
            return true;
        }
        this.thumbnail = this.imageContainer.fit(bound.width, bound.height).asBufferImage();
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.thumbnail != null) {
            Rectangle bound = this.imageBound();
            g.drawImage(this.thumbnail, bound.x, bound.y, this);
        }
    }

    private Rectangle imageBound() {
        Insets insets = new Insets(0, 0, 0, 0);
        Border border = this.getBorder();
        if (border != null) {
            insets = border.getBorderInsets(this);
        }
        double imageAspectRatio = (double)this.imageContainer.getWidth() / (double)this.imageContainer.getHeight();
        double panelAspectRatio = (double)this.getWidth() / (double)this.getHeight();
        int height = 0;
        int width = 0;
        int x = 0;
        int y = 0;
        if (imageAspectRatio < panelAspectRatio) {
            height = this.getHeight() - insets.top - insets.bottom;
            width = (int)((double)height * imageAspectRatio);
            x = (this.getWidth() - insets.left - insets.right - width) / 2;
            y = insets.top;
        } else {
            width = this.getWidth() - insets.left - insets.right;
            height = (int)((double)width / imageAspectRatio);
            x = insets.left;
            y = (this.getHeight() - insets.top - insets.bottom - height) / 2;
        }
        return new Rectangle(x, y, width, height);
    }
}

