/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.list;

import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.swing.combobox.ObjectComboBoxComponentModel;
import net.anwiba.commons.swing.list.IListModel;
import net.anwiba.commons.swing.list.ObjectListComponent;
import net.anwiba.commons.swing.list.ObjectListComponentModel;
import net.anwiba.commons.swing.list.ObjectListConfigurationBuilder;
import net.anwiba.commons.swing.ui.IObjectUi;

public class ObjectListComponentBuilder<T> {
    final ObjectListConfigurationBuilder<T> configurationBuilder = new ObjectListConfigurationBuilder();
    private IListModel<T> model;

    public ObjectListComponentBuilder<T> setObjectUi(IObjectUi<T> objectUi) {
        this.configurationBuilder.setObjectUi(objectUi);
        return this;
    }

    public ObjectListComponentBuilder<T> setSingleSelectionMode() {
        this.configurationBuilder.setSingleSelectionMode();
        return this;
    }

    public ObjectListComponentBuilder<T> setSingleIntervalSelectionMode() {
        this.configurationBuilder.setSingleIntervalSelectionMode();
        return this;
    }

    public ObjectListComponentBuilder<T> setMultiSelectionMode() {
        this.configurationBuilder.setMultiSelectionMode();
        return this;
    }

    public ObjectListComponentBuilder<T> setIconTextGap(int iconTextGap) {
        this.configurationBuilder.setIconTextGap(iconTextGap);
        return this;
    }

    public ObjectListComponentBuilder<T> setVerticalTextPosition(int verticalTextPosition) {
        this.configurationBuilder.setVerticalTextPosition(verticalTextPosition);
        return this;
    }

    public ObjectListComponentBuilder<T> setHorizontalTextPosition(int horizontalTextPosition) {
        this.configurationBuilder.setHorizontalTextPosition(horizontalTextPosition);
        return this;
    }

    public ObjectListComponentBuilder<T> setHorizontalAlignment(int horizontalAlignment) {
        this.configurationBuilder.setHorizontalAlignment(horizontalAlignment);
        return this;
    }

    public ObjectListComponentBuilder<T> setBorder(Border border) {
        this.configurationBuilder.setBorder(border);
        return this;
    }

    public ObjectListComponentBuilder<T> setVisibleRowCount(int visibleRowCount) {
        this.configurationBuilder.setVisibleRowCount(visibleRowCount);
        return this;
    }

    public ObjectListComponentBuilder<T> setModel(IListModel<T> model) {
        this.model = model;
        return this;
    }

    public ObjectListComponentBuilder<T> setValues(T[] values) {
        this.setValues(Arrays.asList(values));
        return this;
    }

    public ObjectListComponentBuilder<T> setValues(List<T> values) {
        this.model = new ObjectComboBoxComponentModel<T>(values);
        return this;
    }

    public ObjectListComponentBuilder<T> setVerticalWrapOrientation() {
        this.configurationBuilder.setVerticalWrapOrientation();
        return this;
    }

    public ObjectListComponentBuilder<T> setHorizontalWrapOrientation() {
        this.configurationBuilder.setHorizontalWrapOrientation();
        return this;
    }

    public ObjectListComponentBuilder<T> setVerticalOrientation() {
        this.configurationBuilder.setVerticalOrientation();
        return this;
    }

    public ObjectListComponentBuilder<T> setMouseListener(MouseListener mouseListener) {
        this.configurationBuilder.setMouseListener(mouseListener);
        return this;
    }

    public ObjectListComponentBuilder<T> setSelectionModel(ISelectionModel<T> selectionModel) {
        this.configurationBuilder.setSelectionModel(selectionModel);
        return this;
    }

    public ObjectListComponentBuilder<T> setTransferHandler(TransferHandler transferHandler) {
        this.configurationBuilder.setTransferHandler(transferHandler);
        return this;
    }

    public ObjectListComponentBuilder<T> setDragDisnabled() {
        this.configurationBuilder.setDragDisabled();
        return this;
    }

    public ObjectListComponentBuilder<T> setDragEnabled() {
        this.configurationBuilder.setDragEnabled();
        return this;
    }

    public ObjectListComponentBuilder<T> setDropReplaceEnabled() {
        this.configurationBuilder.setDropReplaceEnabled();
        return this;
    }

    public ObjectListComponentBuilder<T> setDropReplaceOrInsertEnabled() {
        this.configurationBuilder.setDropReplaceOrInsertEnabled();
        return this;
    }

    public ObjectListComponentBuilder<T> setDropToSelectedEnabled() {
        this.configurationBuilder.setDropToSelectedEnabled();
        return this;
    }

    public ObjectListComponent<T> build() {
        this.model = Optional.ofNullable(this.model).orElseGet(() -> new ObjectListComponentModel(new ArrayList()));
        return new ObjectListComponent<T>(this.configurationBuilder.build(), this.model);
    }
}

