/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.menu;

import java.awt.Container;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import net.anwiba.commons.swing.action.IActionContainerProvider;
import net.anwiba.commons.swing.menu.AbstractMenuItemConfiguration;
import net.anwiba.commons.swing.menu.IMenuItemTypeVisitor;
import net.anwiba.commons.swing.menu.MenuActionItemConfiguration;
import net.anwiba.commons.swing.menu.MenuMenuItemConfiguration;
import net.anwiba.commons.swing.menu.PopupMenuActionItemConfiguration;

public final class MenuItemButtomFactory
implements IMenuItemTypeVisitor<AbstractButton> {
    private final JMenu menu;
    private final AbstractMenuItemConfiguration<?> menuItemConfiguration;

    public MenuItemButtomFactory(JMenu menu, AbstractMenuItemConfiguration<?> menuItemConfiguration) {
        this.menu = menu;
        this.menuItemConfiguration = menuItemConfiguration;
    }

    @Override
    public AbstractButton visitAction() {
        if (this.menuItemConfiguration instanceof PopupMenuActionItemConfiguration) {
            PopupMenuActionItemConfiguration menuActionItemConfiguration = (PopupMenuActionItemConfiguration)this.menuItemConfiguration;
            if (menuActionItemConfiguration.hasActionContainerProvider()) {
                IActionContainerProvider<? extends Container> actionContainerProvider = menuActionItemConfiguration.getActionContainerProvider();
                this.menu.add(actionContainerProvider.getContainer());
                return actionContainerProvider.getButton();
            }
            return this.menu.add(menuActionItemConfiguration.getAction());
        }
        MenuActionItemConfiguration menuActionItemConfiguration = (MenuActionItemConfiguration)this.menuItemConfiguration;
        if (menuActionItemConfiguration.hasActionContainerProvider()) {
            IActionContainerProvider<? extends Container> actionContainerProvider = menuActionItemConfiguration.getActionContainerProvider();
            this.menu.add(actionContainerProvider.getContainer());
            return actionContainerProvider.getButton();
        }
        return this.menu.add(menuActionItemConfiguration.getAction());
    }

    @Override
    public AbstractButton visitMenu() {
        return this.menu.add(((MenuMenuItemConfiguration)this.menuItemConfiguration).getJMenu());
    }
}

