/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.preferences.DummyPreferences;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.swing.dialog.DialogResult;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IAdditionalActionFactory;
import net.anwiba.commons.swing.dialog.IDataStateVisitor;
import net.anwiba.commons.swing.dialog.IDialogResult;
import net.anwiba.commons.swing.dialog.IDialogTypeVisitor;
import net.anwiba.commons.swing.dialog.MessagePanel;
import net.anwiba.commons.swing.preference.IWindowPreferences;
import net.anwiba.commons.swing.preference.WindowPreferences;
import net.anwiba.commons.swing.preference.WindowPrefereneceUpdatingListener;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.swing.utilities.MessageDialogUtilities;

public abstract class AbstractDialog
extends JDialog {
    private static ILogger logger = Logging.getLogger((String)AbstractDialog.class.getName());
    private static final long serialVersionUID = 1L;
    private Action applyAction;
    private final JPanel buttomPanel = new JPanel();
    private final JPanel contentContainerPanel = new JPanel(new BorderLayout());
    private final JPanel detailContainerPanel = new JPanel(new BorderLayout());
    private Container contentPane;
    private final IObjectModel<IDialogResult> dialogResultModel = new ObjectModel((Object)DialogResult.NONE);
    private boolean isDetailsVisible;
    private final MessagePanel messagePanel;
    private AbstractAction okAction;
    private Action tryAction;
    private final IWindowPreferences windowPreferences;
    private final WindowPrefereneceUpdatingListener updater;
    private AbstractAction cancelAction;
    private final IFunction<String, String, RuntimeException> actionButtonTextFactory;
    private final Dimension preferdSize;

    public AbstractDialog(Window owner, String title, IMessage message, Icon icon, DialogType dialogType, boolean modal) {
        this(owner, new WindowPreferences((IPreferences)new DummyPreferences(new String[0])), title, message, icon, dialogType, modal);
    }

    public AbstractDialog(Window owner, IWindowPreferences windowPreferences, String title, IMessage message, Icon icon, DialogType dialogType, boolean modal) {
        this(owner, windowPreferences, null, title, message, icon, true, dialogType, (IFunction<String, String, RuntimeException>)((IFunction)s -> s), new ArrayList<IAdditionalActionFactory>(), modal ? DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
    }

    public AbstractDialog(Window owner, IWindowPreferences windowPreferences, Dimension preferdSize, String title, IMessage message, Icon icon, boolean isMessagePanelEnabled, DialogType dialogType, IFunction<String, String, RuntimeException> actionButtonTextFactory, List<IAdditionalActionFactory> additionalActionFactories, Dialog.ModalityType modalityType) {
        super(owner, title, modalityType);
        this.preferdSize = preferdSize;
        Ensure.ensureArgumentNotNull((Object)windowPreferences);
        this.windowPreferences = windowPreferences;
        this.updater = new WindowPrefereneceUpdatingListener(this, this.windowPreferences);
        this.messagePanel = isMessagePanelEnabled && message != null ? new MessagePanel(message, icon) : null;
        this.actionButtonTextFactory = actionButtonTextFactory;
        this.setIcon(icon);
        this.createView(dialogType, additionalActionFactories);
        this.setMessage(message);
    }

    public void locate() {
        this.removeComponentListener(this.updater);
        this.removeWindowListener(this.updater);
        if (this.windowPreferences.getBounds() == null) {
            if (this.preferdSize == null) {
                this.pack();
            } else {
                this.setSize(this.preferdSize);
            }
            GuiUtilities.center(this);
        } else {
            this.setBounds(this.windowPreferences.getBounds());
        }
        this.addComponentListener(this.updater);
        this.addWindowListener(this.updater);
    }

    protected void checkButton(DataState dataState) {
        dataState.accept(new IDataStateVisitor(){

            @Override
            public void visitInvalide() {
                AbstractDialog.this.setChangeButtonsEnabled(false, false);
            }

            @Override
            public void visitModified() {
                AbstractDialog.this.setChangeButtonsEnabled(true, true);
            }

            @Override
            public void visitUnknown() {
                AbstractDialog.this.setChangeButtonsEnabled(false, false);
            }

            @Override
            public void visitValide() {
                AbstractDialog.this.setChangeButtonsEnabled(false, true);
            }
        });
    }

    protected final void createView(DialogType dialogType, List<IAdditionalActionFactory> additionalActionFactories) {
        Action[] actions;
        this.contentPane = new JPanel();
        this.contentContainerPanel.add(this.contentPane);
        this.buttomPanel.setLayout(new FlowLayout(2));
        Action[] actionArray = actions = this.getActions(dialogType, this.dialogResultModel, additionalActionFactories);
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            JButton button = new JButton(action);
            this.buttomPanel.add(button);
            ++n2;
        }
        this.buttomPanel.setMinimumSize(new Dimension(0, 30));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.contentContainerPanel, "Center");
        panel.add((Component)this.detailContainerPanel, "South");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        if (this.messagePanel != null) {
            this.messagePanel.setMinimumSize(new Dimension(0, 40));
            mainPanel.add("North", this.messagePanel);
        }
        mainPanel.add("Center", panel);
        mainPanel.add("South", this.buttomPanel);
        super.setMinimumSize(new Dimension(0, 120));
        super.setContentPane(mainPanel);
    }

    protected Action[] getActions(DialogType dialogType, IObjectModel<IDialogResult> resultModel, List<IAdditionalActionFactory> additionalActionFactories) {
        IDialogTypeVisitor<Action[]> visitor = new IDialogTypeVisitor<Action[]>(){
            Action[] actions;

            @Override
            public Action[] getResult() {
                return this.actions;
            }

            @Override
            public void visitCancelApplyOk() {
                this.actions = new Action[3];
                this.actions[0] = AbstractDialog.this.getCancelAction();
                this.actions[1] = AbstractDialog.this.getApplyAction();
                this.actions[2] = AbstractDialog.this.getOkAction();
            }

            @Override
            public void visitCancelOk() {
                this.actions = new Action[2];
                this.actions[0] = AbstractDialog.this.getCancelAction();
                this.actions[1] = AbstractDialog.this.getOkAction();
            }

            @Override
            public void visitCancelTryOk() {
                this.actions = new Action[3];
                this.actions[0] = AbstractDialog.this.getCancelAction();
                this.actions[1] = AbstractDialog.this.getTryAction();
                this.actions[2] = AbstractDialog.this.getOkAction();
            }

            @Override
            public void visitClose() {
                this.actions = new Action[1];
                this.actions[0] = AbstractDialog.this.getCloseAction();
            }

            @Override
            public void visitCloseDetails() {
                this.actions = new Action[2];
                this.actions[0] = AbstractDialog.this.getCloseAction();
                this.actions[1] = AbstractDialog.this.getDetailsAction();
            }

            @Override
            public void visitNone() {
                this.actions = new Action[0];
            }

            @Override
            public void visitYesNo() {
                this.actions = new Action[2];
                this.actions[0] = AbstractDialog.this.getYesAction();
                this.actions[1] = AbstractDialog.this.getNoAction();
            }

            @Override
            public void visitCancel() {
                this.actions = new Action[1];
                this.actions[0] = AbstractDialog.this.getCancelAction();
            }
        };
        dialogType.accept(visitor);
        return (Action[])visitor.getResult();
    }

    public final Action getApplyAction() {
        if (this.applyAction == null) {
            this.applyAction = new AbstractAction((String)this.actionButtonTextFactory.execute((Object)DialogMessages.APPLY)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        AbstractDialog.this.apply();
                    }
                    catch (Exception exception) {
                        logger.log(ILevel.ERROR, "", (Throwable)exception);
                    }
                }
            };
            this.applyAction.setEnabled(false);
        }
        return this.applyAction;
    }

    public final Action getCancelAction() {
        if (this.cancelAction == null) {
            this.cancelAction = new AbstractAction((String)this.actionButtonTextFactory.execute((Object)DialogMessages.CANCEL)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        if (AbstractDialog.this.cancel()) {
                            AbstractDialog.this.dialogResultModel.set((Object)DialogResult.CANCEL);
                            AbstractDialog.this.close();
                        }
                    }
                    catch (Exception exception) {
                        logger.log(ILevel.ERROR, "", (Throwable)exception);
                    }
                }
            };
        }
        return this.cancelAction;
    }

    public final AbstractAction getCloseAction() {
        return new AbstractAction((String)this.actionButtonTextFactory.execute((Object)DialogMessages.CLOSE)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.dialogResultModel.set((Object)DialogResult.NONE);
                AbstractDialog.this.close();
            }
        };
    }

    @Override
    public final Container getContentPane() {
        return this.contentPane;
    }

    public final Action getDetailsAction() {
        return new AbstractAction(DialogMessages.OPEN_DETAILS){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Component detailsComponent = AbstractDialog.this.getDetailsComponent();
                if (AbstractDialog.this.isDetailsVisible) {
                    if (detailsComponent != null) {
                        AbstractDialog.this.getDetailContainerPanel().removeAll();
                        AbstractDialog.this.pack();
                    }
                    ((JButton)e.getSource()).setText(DialogMessages.OPEN_DETAILS);
                    AbstractDialog.this.isDetailsVisible = false;
                    return;
                }
                if (detailsComponent != null) {
                    AbstractDialog.this.getDetailContainerPanel().add(detailsComponent);
                    AbstractDialog.this.pack();
                }
                ((JButton)e.getSource()).setText(DialogMessages.CLOSE_DETAILS);
                AbstractDialog.this.isDetailsVisible = true;
            }
        };
    }

    public final Action getNoAction() {
        return new AbstractAction((String)this.actionButtonTextFactory.execute((Object)DialogMessages.NO)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.dialogResultModel.set((Object)DialogResult.NO);
                AbstractDialog.this.close();
            }
        };
    }

    protected final Action getOkAction() {
        return this.getOkAction((String)this.actionButtonTextFactory.execute((Object)DialogMessages.OK));
    }

    protected final Action getOkAction(String title) {
        if (this.okAction == null) {
            this.okAction = new AbstractAction(title){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        if (!AbstractDialog.this.apply()) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        logger.log(ILevel.ERROR, "", (Throwable)exception);
                    }
                    AbstractDialog.this.dialogResultModel.set((Object)DialogResult.OK);
                    AbstractDialog.this.close();
                }
            };
        }
        return this.okAction;
    }

    public final IDialogResult getResult() {
        return (IDialogResult)this.dialogResultModel.get();
    }

    public final Action getTryAction() {
        if (this.tryAction == null) {
            this.tryAction = new AbstractAction(DialogMessages.TRY){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        AbstractDialog.this.tryOut();
                    }
                    catch (Exception exception) {
                        logger.log(ILevel.ERROR, "", (Throwable)exception);
                    }
                }
            };
            this.tryAction.setEnabled(false);
        }
        return this.tryAction;
    }

    public final Action getYesAction() {
        return new AbstractAction(DialogMessages.YES){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.dialogResultModel.set((Object)DialogResult.YES);
                AbstractDialog.this.close();
            }
        };
    }

    protected final void setApplyEnabled(boolean isEnabled) {
        if (this.applyAction != null) {
            GuiUtilities.invokeLater(new ActionEnableRunner(this.applyAction, isEnabled));
        }
    }

    protected final void setChangeButtonsEnabled(boolean isApplyEnabled, boolean isOkEnabled) {
        this.setApplyEnabled(isApplyEnabled);
        this.setOkEnabled(isOkEnabled);
    }

    @Override
    public final void setContentPane(final Container contentPane) {
        if (this.contentPane == contentPane) {
            return;
        }
        this.contentPane = contentPane;
        final JPanel containerPanel = this.contentContainerPanel;
        GuiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                containerPanel.removeAll();
                containerPanel.add(contentPane);
                if (!containerPanel.isVisible()) {
                    return;
                }
                containerPanel.validate();
                containerPanel.repaint();
            }
        });
    }

    public final void setMessage(IMessage message) {
        if (this.messagePanel == null) {
            if (message != null) {
                GuiUtilities.invokeLater(() -> {
                    IDialogResult iDialogResult = MessageDialogUtilities.show(this, this.getTitle(), message);
                });
            }
            return;
        }
        GuiUtilities.invokeLater(() -> this.messagePanel.setMessage(message));
    }

    public final void setIcon(Icon icon) {
        if (this.messagePanel == null) {
            return;
        }
        GuiUtilities.invokeLater(() -> this.messagePanel.setIcon(icon));
    }

    public final void setOkEnabled(boolean isEnabled) {
        if (this.okAction != null) {
            GuiUtilities.invokeLater(new ActionEnableRunner(this.okAction, isEnabled));
        }
    }

    public final void setTryEnabled(boolean isEnabled) {
        if (this.tryAction != null) {
            GuiUtilities.invokeLater(new ActionEnableRunner(this.tryAction, isEnabled));
        }
    }

    protected abstract boolean apply();

    protected abstract boolean tryOut();

    protected abstract boolean cancel();

    protected Component getDetailsComponent() {
        return null;
    }

    protected final JPanel getDetailContainerPanel() {
        return this.detailContainerPanel;
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    public static final class ActionEnableRunner
    implements Runnable {
        private final Action action;
        private final boolean isEnabled;

        public ActionEnableRunner(Action action, boolean isEnabled) {
            this.action = action;
            this.isEnabled = isEnabled;
        }

        @Override
        public void run() {
            this.action.setEnabled(this.isEnabled);
        }
    }
}

