/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectDistributor;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.object.DoubleField;
import net.anwiba.commons.swing.object.DoubleObjectFieldConfigurationBuilder;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.utilities.SpringLayoutUtilities;
import net.anwiba.commons.utilities.interval.DoubleInterval;
import net.anwiba.commons.utilities.number.StringToDoubleConverter;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class DoubleIntervalField
implements IObjectField<DoubleInterval> {
    private static ILogger logger = Logging.getLogger((String)DoubleIntervalField.class.getName());
    private final IObjectModel<IValidationResult> validationModel;
    private final IObjectModel<IValidationResult> minimumValidationModel = new ObjectModel((Object)IValidationResult.valid());
    private final IObjectModel<IValidationResult> maximumValidationModel = new ObjectModel((Object)IValidationResult.valid());
    private final IObjectModel<Double> minimumValueModel = new ObjectModel();
    private final IObjectModel<Double> maximumValueModel = new ObjectModel();
    private final IObjectModel<DoubleInterval> model;
    private JPanel component;
    private final double maximum;
    private final double minimum;
    private final IConverter<Double, String, RuntimeException> toStringFormater;

    public DoubleIntervalField(IConverter<Double, String, RuntimeException> toStringFormater, double minimum, double maximum, final IObjectModel<DoubleInterval> model, final IObjectModel<IValidationResult> validationModel) {
        this.model = model;
        this.minimum = minimum;
        this.maximum = maximum;
        this.toStringFormater = toStringFormater;
        this.validationModel = validationModel;
        final IObjectModel<Double> minimumValueModel = this.minimumValueModel;
        final IObjectModel<Double> maximumValueModel = this.maximumValueModel;
        minimumValueModel.set(model.get() == null ? null : Double.valueOf(((DoubleInterval)model.get()).getMinimum()));
        maximumValueModel.set(model.get() == null ? null : Double.valueOf(((DoubleInterval)model.get()).getMaximum()));
        final IObjectModel<IValidationResult> minimumValidationModel = this.minimumValidationModel;
        final IObjectModel<IValidationResult> maximumValidationModel = this.maximumValidationModel;
        validationModel.set((Object)this.checkValid());
        IChangeableObjectListener validationListener = new IChangeableObjectListener(){

            public void objectChanged() {
                logger.log(ILevel.DEBUG, "validation state changed");
                logger.log(ILevel.DEBUG, MessageFormat.format("minimum value: {0}", ((IValidationResult)minimumValidationModel.get()).isValid() ? "valid" : MessageFormat.format("invalid: {0}", ((IValidationResult)minimumValidationModel.get()).getMessage())));
                logger.log(ILevel.DEBUG, "maximum value: " + (((IValidationResult)maximumValidationModel.get()).isValid() ? "valid" : MessageFormat.format("invalid: {0}", ((IValidationResult)maximumValidationModel.get()).getMessage())));
                if (!((IValidationResult)minimumValidationModel.get()).isValid()) {
                    validationModel.set((Object)IValidationResult.inValid((String)("Illegal minimum value. " + ((IValidationResult)minimumValidationModel.get()).getMessage())));
                    return;
                }
                if (!((IValidationResult)maximumValidationModel.get()).isValid()) {
                    validationModel.set((Object)IValidationResult.inValid((String)("Illegal maximum value. " + ((IValidationResult)maximumValidationModel.get()).getMessage())));
                    return;
                }
                IValidationResult validationResult = DoubleIntervalField.this.checkValid();
                if (validationResult.isValid()) {
                    model.set(minimumValueModel.get() == null && maximumValueModel.get() == null ? null : new DoubleInterval(((Double)minimumValueModel.get()).doubleValue(), ((Double)maximumValueModel.get()).doubleValue()));
                }
                validationModel.set((Object)validationResult);
            }
        };
        minimumValidationModel.addChangeListener(validationListener);
        maximumValidationModel.addChangeListener(validationListener);
        model.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                logger.log(ILevel.DEBUG, MessageFormat.format("model changed: {0}", model.get()));
                minimumValueModel.set(model.get() == null ? null : Double.valueOf(((DoubleInterval)model.get()).getMinimum()));
                maximumValueModel.set(model.get() == null ? null : Double.valueOf(((DoubleInterval)model.get()).getMaximum()));
            }
        });
        minimumValueModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                logger.log(ILevel.DEBUG, MessageFormat.format("minimum model changed: {0}", minimumValueModel.get()));
                IValidationResult validationResult = DoubleIntervalField.this.checkValid();
                if (validationResult.isValid()) {
                    model.set(minimumValueModel.get() == null && maximumValueModel.get() == null ? null : new DoubleInterval(((Double)minimumValueModel.get()).doubleValue(), ((Double)maximumValueModel.get()).doubleValue()));
                }
                validationModel.set((Object)validationResult);
            }
        });
        maximumValueModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                logger.log(ILevel.DEBUG, MessageFormat.format("maximum model changed: {0}", maximumValueModel.get()));
                IValidationResult validationResult = DoubleIntervalField.this.checkValid();
                if (validationResult.isValid()) {
                    model.set(minimumValueModel.get() == null && maximumValueModel.get() == null ? null : new DoubleInterval(((Double)minimumValueModel.get()).doubleValue(), ((Double)maximumValueModel.get()).doubleValue()));
                }
                validationModel.set((Object)validationResult);
            }
        });
    }

    protected IValidationResult checkValid() {
        if (this.minimumValueModel.get() == null && this.maximumValueModel.get() == null || this.minimumValueModel.get() != null && this.maximumValueModel.get() != null && (Double)this.minimumValueModel.get() < (Double)this.maximumValueModel.get()) {
            return IValidationResult.valid();
        }
        if (this.minimumValueModel.get() == null) {
            return IValidationResult.inValid((String)"Missing minimum value.");
        }
        if (this.maximumValueModel.get() == null) {
            return IValidationResult.inValid((String)"Missing maximum value.");
        }
        if (((Double)this.maximumValueModel.get()).doubleValue() == ((Double)this.minimumValueModel.get()).doubleValue()) {
            return IValidationResult.inValid((String)"Minimum value equals maximum value.");
        }
        return IValidationResult.inValid((String)"Minimum value is larger than maximum value.");
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
        return this.component;
    }

    private JPanel createComponent() {
        ValueValidator validator = new ValueValidator(this.minimum, this.maximum);
        final DoubleField minimumField = this.createDoubleField(this.minimumValueModel, this.minimumValidationModel, validator);
        DoubleField maximumField = this.createDoubleField(this.maximumValueModel, this.maximumValidationModel, validator);
        JPanel panel = new JPanel(new SpringLayout()){

            @Override
            public void requestFocus() {
                minimumField.getComponent().requestFocus();
            }
        };
        panel.add(minimumField.getComponent());
        panel.add(maximumField.getComponent());
        SpringLayoutUtilities.makeCompactGrid(panel, 2, 1, 0, 0, 6, 0);
        return panel;
    }

    private DoubleField createDoubleField(IObjectModel<Double> valueModel, IObjectModel<IValidationResult> validationModel, ValueValidator validator) {
        DoubleObjectFieldConfigurationBuilder builder = new DoubleObjectFieldConfigurationBuilder();
        builder.setModel(valueModel);
        builder.setValidStateModel(validationModel);
        builder.setValidator(validator);
        builder.setToStringConverter(this.toStringFormater);
        return new DoubleField(builder.build());
    }

    @Override
    public IObjectModel<DoubleInterval> getModel() {
        return this.model;
    }

    @Override
    public IObjectDistributor<IValidationResult> getValidationResultDistributor() {
        return this.validationModel;
    }

    public static final class ValueValidator
    implements IValidator<String> {
        private final double minimum;
        private final double maximum;
        StringToDoubleConverter converter = new StringToDoubleConverter();

        public ValueValidator(double minimum, double maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public IValidationResult validate(String string) {
            try {
                boolean isInBoundery;
                Double valueObject = this.converter.convert(string);
                if (valueObject == null) {
                    return IValidationResult.valid();
                }
                double value = valueObject;
                boolean bl = Double.isNaN(this.minimum) ? (Double.isNaN(this.maximum) ? true : value <= this.maximum) : (Double.isNaN(this.maximum) ? this.minimum <= value : (isInBoundery = this.minimum <= value && value <= this.maximum));
                if (isInBoundery) {
                    return IValidationResult.valid();
                }
                return IValidationResult.inValid((String)MessageFormat.format("Value is out of bounderies ({0}, {1})", this.toString(this.minimum), this.toString(this.maximum)));
            }
            catch (NumberFormatException exception) {
                return IValidationResult.inValid((String)exception.getLocalizedMessage());
            }
        }

        private String toString(double value) {
            if (Double.isNaN(value)) {
                return "none";
            }
            return String.valueOf(value);
        }
    }
}

