/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.parameter;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.utilities.parameter.IParameter;
import net.anwiba.commons.utilities.parameter.IParameters;
import net.anwiba.commons.utilities.parameter.Parameter;
import net.anwiba.commons.utilities.parameter.Parameters;

public class ParameterTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private IParameters parameters = new Parameters(new ArrayList());
    private final boolean isEditable;

    public ParameterTableModel() {
        this(false);
    }

    public ParameterTableModel(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public void setParameters(IParameters parameters) {
        this.parameters = parameters == null ? new Parameters(new ArrayList()) : parameters;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.parameters.getNumberOfParameter();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        throw new UnreachableCodeReachedException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!(this.isEditable || -1 < rowIndex && rowIndex < this.parameters.getNumberOfParameter())) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new UnreachableCodeReachedException();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return DialogMessages.NAME;
            }
            case 1: {
                return DialogMessages.VALUE;
            }
        }
        throw new UnreachableCodeReachedException();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (!(this.isEditable || -1 < rowIndex && rowIndex < this.parameters.getNumberOfParameter())) {
            throw new IllegalArgumentException();
        }
        IParameter parameter = this.parameters.getParameter(rowIndex);
        this.parameters = this.parameters.adapt(rowIndex, (IParameter)new Parameter(parameter.getName(), ObjectUtilities.toString((Object)value)));
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.parameters.getParameter(rowIndex).getName();
            }
            case 1: {
                return this.parameters.getParameter(rowIndex).getValue();
            }
        }
        throw new UnreachableCodeReachedException();
    }

    public IParameters getParameters() {
        return this.parameters;
    }
}

