/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.util.List;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.swing.table.IColumnClassProvider;
import net.anwiba.commons.swing.table.IColumnValueAdaptor;
import net.anwiba.commons.swing.table.IColumnValueProvider;
import net.anwiba.commons.swing.table.IKeyListenerFactory;
import net.anwiba.commons.swing.table.IMouseListenerFactory;
import net.anwiba.commons.swing.table.IObjectListColumnConfiguration;
import net.anwiba.commons.swing.table.IObjectListTableConfiguration;
import net.anwiba.commons.swing.table.ObjectTableConfiguration;
import net.anwiba.commons.swing.table.action.ITableActionConfiguration;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;
import net.anwiba.commons.utilities.collection.ListUtilities;

public class ObjectListTableConfiguration<T>
extends ObjectTableConfiguration<T>
implements IObjectListTableConfiguration<T> {
    private List<IColumnValueProvider<T>> columnValueProviders;
    private List<IColumnValueAdaptor<T>> columnValueAdaptors;
    private final IColumToStringConverter columnToStringConverter;
    private IColumnClassProvider columnClassProvider;

    public ObjectListTableConfiguration(IColumToStringConverter columnToStringConverter, int autoRizeMode, int selectionMode, int preferredVisibleRowCount, final List<IObjectListColumnConfiguration<T>> columnConfigurations, IMouseListenerFactory<T> mouseListenerFactory, IKeyListenerFactory<T> keyListenerFactory, ITableActionConfiguration<T> actionConfiguration) {
        super(autoRizeMode, selectionMode, preferredVisibleRowCount, columnConfigurations, mouseListenerFactory, keyListenerFactory, actionConfiguration);
        this.columnToStringConverter = columnToStringConverter;
        this.columnValueProviders = ListUtilities.convert(columnConfigurations, (IConverter)new IConverter<IObjectListColumnConfiguration<T>, IColumnValueProvider<T>, RuntimeException>(){

            public IColumnValueProvider<T> convert(IObjectListColumnConfiguration<T> input) throws RuntimeException {
                return input.getColumnValueProvider();
            }
        });
        this.columnValueAdaptors = ListUtilities.convert(columnConfigurations, (IConverter)new IConverter<IObjectListColumnConfiguration<T>, IColumnValueAdaptor<T>, RuntimeException>(){

            public IColumnValueAdaptor<T> convert(IObjectListColumnConfiguration<T> input) throws RuntimeException {
                return input.getColumnValueAdaptor();
            }
        });
        this.columnClassProvider = new IColumnClassProvider(){

            @Override
            public Class<?> getClass(int columnIndex) {
                IObjectListColumnConfiguration configuration = (IObjectListColumnConfiguration)columnConfigurations.get(columnIndex);
                if (configuration == null) {
                    return Object.class;
                }
                return configuration.getColumnClass();
            }
        };
    }

    @Override
    public List<IColumnValueProvider<T>> getColumnValueProviders() {
        return this.columnValueProviders;
    }

    @Override
    public List<IColumnValueAdaptor<T>> getColumnValueAdaptors() {
        return this.columnValueAdaptors;
    }

    @Override
    public boolean isFilterable() {
        return this.columnToStringConverter != null;
    }

    @Override
    public IColumToStringConverter getRowFilterToStringConverter() {
        return this.columnToStringConverter;
    }

    @Override
    public IColumnClassProvider getColumnClassProvider() {
        return this.columnClassProvider;
    }
}

