/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.component.search.demo;

import de.jdemo.annotation.Demo;
import de.jdemo.extensions.SwingDemoCase;
import de.jdemo.junit.DemoAsTestRunner;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.text.Caret;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.swing.component.search.ISearchEngine;
import net.anwiba.commons.swing.component.search.SearchComponent;
import net.anwiba.commons.swing.component.search.text.DocumentSearchEngine;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.utilities.string.IStringPart;
import net.anwiba.commons.utilities.string.StringUtilities;
import org.junit.runner.RunWith;

@RunWith(value=DemoAsTestRunner.class)
public class SearchComponentDemo
extends SwingDemoCase {
    @Demo
    public void demo() {
        JPanel contentPane = new JPanel(new BorderLayout());
        String text = this.getText();
        JTextArea textArea = new JTextArea(text);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setCaretColor(Color.BLACK);
        Caret caret = textArea.getCaret();
        caret.setVisible(true);
        caret.setSelectionVisible(true);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(400, 300));
        contentPane.add((Component)scrollPane, "Center");
        DocumentSearchEngine engine = new DocumentSearchEngine(textArea.getDocument());
        StringConditonFactory stringToConditionFactory = new StringConditonFactory();
        SearchComponent searchComponent = new SearchComponent((ISearchEngine)engine, (IFactory)stringToConditionFactory, new JComponent[0]);
        JToolBar toolbar = new JToolBar();
        toolbar.add(new ActivatSearchAction(null, GuiIcons.SEARCH_ICON.getSmallIcon(), (SearchComponent<String, IStringPart>)searchComponent, contentPane));
        engine.getResultCursorModel().addChangeListener((IChangeableObjectListener)new ResultMarker((ISearchEngine<String, IStringPart>)engine, caret));
        contentPane.add((Component)toolbar, "North");
        this.show(contentPane);
    }

    private String getText() {
        return "Warburg [\u02c8va\u02d0.bu\u0250k] (niederdeutsch: Warb(e)rich: lateinisch: Warburgum oder Varburgum) ist eine Stadt im ostwestf\u00e4lischen Kreis H\u00f6xter im Osten Nordrhein-Westfalens (Deutschland). Es ist ein Mittelzentrum und mit rund 24.000 Einwohnern die gr\u00f6\u00dfte Stadt der Warburger B\u00f6rde. Die Stadt wurde um 1010 erstmals schriftlich erw\u00e4hnt, die erste Nennung der Stadt als geschlossene Ortschaft stammt aus dem Jahr 1036. Zudem geh\u00f6rte Warburg zur westf\u00e4lischen Hanse. Das Stadtbild ist durch die historischen Bauten, Stein- und Fachwerkh\u00e4user, und die Lage auf einem Bergr\u00fccken gepr\u00e4gt. Warburg wird auch als Rothenburg Westfalens bezeichnet.\nWarburg liegt im Osten des Landes Nordrhein-Westfalen und im S\u00fcden des Kreises H\u00f6xter sowie etwa 27 Kilometer s\u00fcdwestlich des Dreil\u00e4nderecks Hessen\u2013Niedersachsen\u2013Nordrhein-Westfalen. Im S\u00fcden grenzt das Stadtgebiet an das Land Hessen. Naturr\u00e4umlich liegt Warburg im S\u00fcden der Warburger B\u00f6rde, einer fruchtbaren Niederung mit fruchtbarem L\u00f6\u00dfboden und geringen Baumbest\u00e4nden. Die B\u00f6rde wird \u00fcberwiegend landwirtschaftlich genutzt. Im S\u00fcdwesten ber\u00fchrt das Stadtgebiet die Ausl\u00e4ufer des Sauerlandes, im Nordwesten die des Eggegebirges. Im Norden und Nordosten schlie\u00dft sich die eigentliche Warburger B\u00f6rde an, s\u00fcdlich das Westhessische Bergland. Die n\u00e4chstgelegenen Oberzentren sind Paderborn (nordwestlich: 27 km Landstra\u00dfe, 40 km Autobahn) und Kassel (s\u00fcd\u00f6stlich: 35 km Landstra\u00dfe/Autobahn) und G\u00f6ttingen (\u00f6stlich: 76 km Landstra\u00dfe, 98 km Autobahn).";
    }

    public static final class ActivatSearchAction
    extends AbstractAction {
        private final SearchComponent<String, IStringPart> searchComponent;
        private final JPanel contentPane;

        public ActivatSearchAction(String name, Icon icon, SearchComponent<String, IStringPart> searchComponent, JPanel contentPane) {
            super(name, icon);
            this.searchComponent = searchComponent;
            this.contentPane = contentPane;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final JComponent component = this.searchComponent.getComponent();
            if (component.getParent() != null) {
                return;
            }
            final JPanel contentPane = this.contentPane;
            GuiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    contentPane.add((Component)component, "South");
                    component.grabFocus();
                    contentPane.validate();
                }
            });
        }
    }

    public static final class ComponentRemover
    implements IProcedure<Component, RuntimeException> {
        private final JPanel contentPane;

        public ComponentRemover(JPanel contentPane) {
            this.contentPane = contentPane;
        }

        public void execute(final Component component) {
            if (component == null || component.getParent() == null) {
                return;
            }
            final JPanel contentPane = this.contentPane;
            GuiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    contentPane.remove(component);
                    contentPane.validate();
                }
            });
        }
    }

    public static final class ResultMarker
    implements IChangeableObjectListener {
        private final ISearchEngine<String, IStringPart> engine;
        private final Caret caret;

        public ResultMarker(ISearchEngine<String, IStringPart> engine, Caret caret) {
            this.engine = engine;
            this.caret = caret;
        }

        public void objectChanged() {
            final IStringPart part = (IStringPart)this.engine.getResultCursorModel().get();
            if (part == null) {
                return;
            }
            GuiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    caret.setVisible(true);
                    caret.setSelectionVisible(true);
                    caret.setDot(part.getPosition());
                    caret.moveDot(part.getPosition() + part.getLength());
                }
            });
        }
    }

    public static final class StringConditonFactory
    implements IFactory<String, String, RuntimeException> {
        public String create(String string) {
            return StringUtilities.isNullOrEmpty((String)string) ? null : string;
        }
    }
}

