/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.demo;

import de.jdemo.annotation.Demo;
import de.jdemo.extensions.SwingDemoCase;
import de.jdemo.junit.DemoAsTestRunner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.swing.object.StringField;
import net.anwiba.commons.swing.table.ColumnConfiguration;
import net.anwiba.commons.swing.table.FilterableObjectTableModel;
import net.anwiba.commons.swing.table.IColumnConfiguration;
import net.anwiba.commons.swing.table.IObjectTableConfiguration;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.IRowFilter;
import net.anwiba.commons.swing.table.ISelectionIndexModel;
import net.anwiba.commons.swing.table.ObjectTable;
import net.anwiba.commons.swing.table.ObjectTableConfigurationBuilder;
import net.anwiba.commons.swing.table.action.AddTableRowActionFactory;
import net.anwiba.commons.swing.table.action.EditTableActionFactory;
import net.anwiba.commons.swing.table.action.ITableActionClosure;
import net.anwiba.commons.swing.table.action.ITableActionFactory;
import net.anwiba.commons.swing.table.action.MoveTableRowDownActionFactory;
import net.anwiba.commons.swing.table.action.MoveTableRowUpActionFactory;
import net.anwiba.commons.swing.table.action.RemoveTableRowActionFactory;
import net.anwiba.commons.swing.table.demo.DemoObject;
import net.anwiba.commons.swing.table.demo.DemoObjectFactory;
import net.anwiba.commons.swing.table.demo.DemoTableModel;
import net.anwiba.commons.swing.table.filter.ColumnToStingConverter;
import net.anwiba.commons.swing.table.filter.ContainsFilter;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;
import net.anwiba.commons.swing.table.renderer.BooleanRenderer;
import net.anwiba.commons.swing.table.renderer.NumberTableCellRenderer;
import net.anwiba.commons.swing.table.renderer.ObjectTableCellRenderer;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;
import org.junit.runner.RunWith;

@RunWith(value=DemoAsTestRunner.class)
public class ObjectTableDemo
extends SwingDemoCase {
    public IObjectTableConfiguration<DemoObject> createObjectTableConfiguration(boolean isSortable) {
        ObjectTableConfigurationBuilder builder = new ObjectTableConfigurationBuilder();
        this.addColumnDescriptions((ObjectTableConfigurationBuilder<DemoObject>)builder, isSortable);
        return builder.build();
    }

    public void addColumnDescriptions(ObjectTableConfigurationBuilder<DemoObject> builder, boolean isSortable) {
        builder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)"Nummer", (TableCellRenderer)new NumberTableCellRenderer(), 80, isSortable, null));
        builder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)"Name", (TableCellRenderer)new ObjectTableCellRenderer(), 200, isSortable, null));
        builder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)"Value", (TableCellRenderer)new NumberTableCellRenderer(), 200, isSortable, null));
        builder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)"Flag", (TableCellRenderer)new BooleanRenderer(), 40, isSortable, null));
    }

    @Demo
    public void actions() {
        final DemoObjectFactory factory = new DemoObjectFactory(4711L);
        ObjectTableConfigurationBuilder builder = new ObjectTableConfigurationBuilder();
        this.addColumnDescriptions((ObjectTableConfigurationBuilder<DemoObject>)builder, true);
        builder.addActionFactory((ITableActionFactory)new AddTableRowActionFactory((ITableActionClosure)new ITableActionClosure<DemoObject>(){

            public void execute(Component component, IObjectTableModel<DemoObject> tableModel, ISelectionIndexModel<DemoObject> selectionIndexModel) {
                tableModel.add((Object[])new DemoObject[]{factory.createObject()});
                selectionIndexModel.set(tableModel.size() - 1);
            }
        }));
        builder.addActionFactory((ITableActionFactory)new EditTableActionFactory((ITableActionClosure)new ITableActionClosure<DemoObject>(){

            public void execute(Component component, IObjectTableModel<DemoObject> tableModel, ISelectionIndexModel<DemoObject> selectionIndexModel) {
                int index = selectionIndexModel.getMinimum();
                DemoObject object = factory.createObject();
                tableModel.set(index, (Object)object);
            }
        }));
        builder.addActionFactory((ITableActionFactory)new RemoveTableRowActionFactory());
        builder.addActionFactory((ITableActionFactory)new MoveTableRowUpActionFactory());
        builder.addActionFactory((ITableActionFactory)new MoveTableRowDownActionFactory());
        this.show(new ObjectTable(builder.build(), (IObjectTableModel)new DemoTableModel(factory.createObjectList(20))).getComponent());
    }

    @Demo
    public void sortable() {
        DemoObjectFactory factory = new DemoObjectFactory(4711L);
        ObjectTableConfigurationBuilder builder = new ObjectTableConfigurationBuilder();
        builder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)"Nummer", (TableCellRenderer)new NumberTableCellRenderer(), 80, true, null));
        builder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)"Name", (TableCellRenderer)new ObjectTableCellRenderer(), 200, true, null));
        builder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)"Value", (TableCellRenderer)new NumberTableCellRenderer(), 200, false, null));
        builder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)"Flag", (TableCellRenderer)new BooleanRenderer(), 40, true, null));
        this.show(new ObjectTable(builder.build(), (IObjectTableModel)new DemoTableModel(factory.createObjectList(20))).getComponent());
    }

    @Demo
    public void selection() {
        DemoObjectFactory factory = new DemoObjectFactory(4711L);
        JPanel panel = new JPanel(new GridLayout(2, 1));
        List<DemoObject> objectList = factory.createObjectList(20);
        final ObjectTable masterTable = new ObjectTable(this.createObjectTableConfiguration(true), (IObjectTableModel)new DemoTableModel(objectList));
        final ObjectTable minorTable = new ObjectTable(this.createObjectTableConfiguration(true), (IObjectTableModel)new DemoTableModel(objectList));
        panel.add(masterTable.getComponent());
        panel.add(minorTable.getComponent());
        masterTable.getSelectionModel().addSelectionListener((ISelectionListener)new ISelectionListener<DemoObject>(){

            public void selectionChanged(SelectionEvent<DemoObject> event) {
                List objects = IterableUtilities.asList((Iterable)masterTable.getSelectionModel().getSelectedObjects());
                minorTable.getSelectionModel().setSelectedObjects((Collection)objects);
            }
        });
        minorTable.getSelectionModel().addSelectionListener((ISelectionListener)new ISelectionListener<DemoObject>(){

            public void selectionChanged(SelectionEvent<DemoObject> event) {
                List objects = IterableUtilities.asList((Iterable)minorTable.getSelectionModel().getSelectedObjects());
                masterTable.getSelectionModel().setSelectedObjects((Collection)objects);
            }
        });
        this.show(panel);
    }

    @Demo
    public void filterable() {
        DemoObjectFactory factory = new DemoObjectFactory(4711L);
        DemoTableModel tableModel = new DemoTableModel(factory.createObjectList(20));
        final FilterableObjectTableModel filterableObjectTableModel = new FilterableObjectTableModel((IObjectTableModel)tableModel);
        JPanel panel = new JPanel(new BorderLayout());
        StringField stringField = new StringField();
        final IObjectModel model = stringField.getModel();
        model.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                String value = (String)model.get();
                if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                    filterableObjectTableModel.setRowFilter(null);
                    return;
                }
                filterableObjectTableModel.setRowFilter((IRowFilter)new ContainsFilter(value, (IColumToStringConverter)new ColumnToStingConverter(new int[]{0, 1, 2, 3})));
            }
        });
        ObjectTable objectTable = new ObjectTable(this.createObjectTableConfiguration(true), (IObjectTableModel)filterableObjectTableModel);
        panel.add((Component)stringField.getComponent(), "North");
        panel.add((Component)objectTable.getComponent(), "Center");
        this.show(panel);
    }
}

