/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.action;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.swing.action.ActionCustomization;
import net.anwiba.commons.swing.action.ActionProcedurBuilder;
import net.anwiba.commons.swing.action.IActionConfiguration;
import net.anwiba.commons.swing.action.IActionCustomization;
import net.anwiba.commons.swing.action.IActionProcedure;
import net.anwiba.commons.swing.action.IActionTask;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.thread.cancel.ICanceler;

public class ActionConfigurationBuilder {
    private IBooleanModel enabledModel = new BooleanModel(true);
    private String tooltip = null;
    private IGuiIcon icon = null;
    private String name = null;
    private IActionProcedure procedure = null;
    private IGuiIcon selectedIcon = null;
    private IBlock<InvocationTargetException> task;

    public ActionConfigurationBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ActionConfigurationBuilder setSelectedIcon(IGuiIcon selectedIcon) {
        this.selectedIcon = selectedIcon;
        return this;
    }

    public ActionConfigurationBuilder setIcon(IGuiIcon icon) {
        this.icon = icon;
        return this;
    }

    public ActionConfigurationBuilder setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ActionConfigurationBuilder setEnabledModel(IBooleanModel enabledModel) {
        this.enabledModel = enabledModel;
        return this;
    }

    public ActionConfigurationBuilder setProcedure(IActionProcedure closure) {
        if (this.procedure != null) {
            this.task = null;
        }
        this.procedure = closure;
        return this;
    }

    public ActionConfigurationBuilder setTask(IBlock<InvocationTargetException> task) {
        if (task != null) {
            this.procedure = null;
        }
        this.task = task;
        return this;
    }

    public IActionConfiguration build() {
        final IBooleanModel enabledModel = this.enabledModel;
        final ActionCustomization customization = new ActionCustomization(this.name, this.icon, this.tooltip);
        final IActionProcedure procedure = this.createProcedure();
        return new IActionConfiguration(){

            @Override
            public IBooleanModel getEnabledModel() {
                return enabledModel;
            }

            @Override
            public IActionCustomization getCustomization() {
                return customization;
            }

            @Override
            public IActionProcedure getProcedure() {
                return procedure;
            }
        };
    }

    private IActionProcedure createProcedure() {
        if (this.procedure != null) {
            return this.procedure;
        }
        if (this.task != null) {
            return new ActionProcedurBuilder().setTitle(this.name).setTask(new IActionTask<Void, Void>(){

                @Override
                public Void excecute(IMessageCollector monitor, ICanceler canceler, Void value) throws InvocationTargetException, InterruptedException {
                    ActionConfigurationBuilder.this.task.execute();
                    return null;
                }
            }).build();
        }
        return new IActionProcedure(){

            @Override
            public void execute(Component value) throws RuntimeException {
            }
        };
    }
}

